package gamelib;

import java.util.List;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.tiled.TiledMap;

/**
 *
 * @author saren
 */
public interface Level {

    Player getPlayer();
    void setPlayer(Player player);
    List<Actor> getActors();
    boolean add(Actor actor);
    boolean remove(Actor actor);
    TiledMap getTiledMap();
    int getID();
    void update(GameContainer container, int delta, Level level);
    void render(GameContainer container, Graphics g, Level level);
}
