package gamelib;

import items.Item;


/**
 *
 * @author saren
 */
public interface Backpack {

    /**
     * Prida do batoha predmet
     * @param item predmet, ktory sa prida
     * @return <code>true</code> ak bol predmet uspesne pridany do batoha
     */
    public boolean add(Item item);

    /**
     * Odoberie predmet z batoha
     * @param string jedinecny nazov, ktorym je predmet na odstranenie identifikovany
     * @return referencia na predmet, ktory bol z batoha odstraneny
     */
    public Item removeItem(String string);

    /**
     * Najde predmet v batohu
     * @param string jedinecny nazov, ktorym je predmet identifikovany
     * @return najdeny predmet
     */
    public Item getItem(String string);

    /**
     * Ziska kapacitu batoha
     * @return kapacita batoha
     */
    public int getCapacity();

    /**
     * Ziska aktualnu velkost batoha
     * @return pocet predmetov aktualne ulozenych v batohu
     */
    public int getCurrentSize();

    /**
     * Ziska predmet, ktory je v ramci batoha zvoleny ako aktualny pre dalsiu manipulaciu
     * @return aktualny predmet
     */
    public Item getCurrentItem();

    /**
     * Nastavi predmet, ktory bude v ramci batoha zvoleny ako aktualny pre dalsiu manipulaciu
     * @param item predmet, ktory bude nastaveny ako aktualny
     */
    public void setCurrentItem(Item item);

}
