/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSet {
    private ArrayList chars = new ArrayList();
    private ArrayList kerning = new ArrayList();
    private String fontName;
    private int height;
    private int width;
    private String setName;
    private String imageName;
    private int size;
    private int lineHeight;

    public DataSet(String fontName, int size, int lineHeight, int width, int height, String setName, String imageName) {
        this.fontName = fontName;
        this.height = height;
        this.width = width;
        this.setName = setName;
        this.imageName = imageName;
        this.size = size;
        this.lineHeight = lineHeight;
    }

    public void clearKerning() {
        this.kerning.clear();
    }

    public void dumpStats() {
        System.out.println("Kerning Count: " + this.kerning.size());
    }

    public void toAngelCodeText(PrintStream out, String imageName) {
        int i;
        out.println("info face=\"" + this.fontName + "\" size=" + this.size + " bold=0 italic=0 charset=\"" + this.setName + "\" unicode=0 stretchH=100 smooth=1 aa=1 padding=0,0,0,0 spacing=1,1");
        out.println("common lineHeight=" + this.lineHeight + " base=26 scaleW=" + this.width + " scaleH=" + this.height + " pages=1 packed=0");
        out.println("page id=0 file=\"" + imageName + "\"");
        out.println("chars count=" + this.chars.size());
        for (i = 0; i < this.chars.size(); ++i) {
            CharData c = (CharData)this.chars.get(i);
            out.println("char id=" + c.getID() + "   x=" + c.getX() + "     y=" + c.getY() + "     width=" + c.getWidth() + "     height=" + c.getHeight() + "     xoffset=0     yoffset=" + c.getYOffset() + "    xadvance=" + c.getXAdvance() + "     page=0  chnl=0 ");
        }
        out.println("kernings count=" + this.kerning.size());
        for (i = 0; i < this.kerning.size(); ++i) {
            KerningData k = (KerningData)this.kerning.get(i);
            out.println("kerning first=" + k.first + "  second=" + k.second + "  amount=" + k.offset);
        }
    }

    public void toAngelCodeXML(PrintStream out, String imageName) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("font");
            document.appendChild(root);
            Element info = document.createElement("info");
            info.setAttribute("face", this.fontName);
            info.setAttribute("size", "" + this.size);
            info.setAttribute("bold", "0");
            info.setAttribute("italic", "0");
            info.setAttribute("charSet", this.setName);
            info.setAttribute("unicode", "0");
            info.setAttribute("stretchH", "100");
            info.setAttribute("smooth", "0");
            info.setAttribute("aa", "0");
            info.setAttribute("padding", "0,0,0,0");
            info.setAttribute("spacing", "0,0");
            root.appendChild(info);
            Element common = document.createElement("common");
            common.setAttribute("lineHeight", "" + this.lineHeight);
            common.setAttribute("base", "0");
            common.setAttribute("scaleW", "" + this.width);
            common.setAttribute("scaleH", "" + this.height);
            common.setAttribute("pages", "1");
            common.setAttribute("packed", "0");
            root.appendChild(common);
            Element pages = document.createElement("pages");
            Element page = document.createElement("page");
            page.setAttribute("id", "0");
            page.setAttribute("file", imageName);
            root.appendChild(pages);
            pages.appendChild(page);
            Element charsElement = document.createElement("chars");
            charsElement.setAttribute("count", "" + this.chars.size());
            root.appendChild(charsElement);
            for (int i = 0; i < this.chars.size(); ++i) {
                CharData c = (CharData)this.chars.get(i);
                Element charElement = document.createElement("char");
                charElement.setAttribute("id", "" + c.getID());
                charElement.setAttribute("x", "" + c.getX());
                charElement.setAttribute("y", "" + c.getY());
                charElement.setAttribute("width", "" + c.getWidth());
                charElement.setAttribute("height", "" + c.getHeight());
                charElement.setAttribute("xoffset", "0");
                charElement.setAttribute("yoffset", "" + c.getYOffset());
                charElement.setAttribute("xadvance", "" + c.getXAdvance());
                charElement.setAttribute("page", "0");
                charElement.setAttribute("chnl", "0");
                charsElement.appendChild(charElement);
            }
            Element kernsElement = document.createElement("kernings");
            kernsElement.setAttribute("count", "" + this.kerning.size());
            root.appendChild(kernsElement);
            for (int i = 0; i < this.kerning.size(); ++i) {
                KerningData k = (KerningData)this.kerning.get(i);
                Element kernElement = document.createElement("kerning");
                kernElement.setAttribute("first", "" + k.first);
                kernElement.setAttribute("second", "" + k.second);
                kernElement.setAttribute("amount", "" + k.offset);
                kernsElement.appendChild(kernElement);
            }
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)out, "utf-8"));
            DOMSource source = new DOMSource(document);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(2));
            Transformer xformer = factory.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException x = new IOException();
            x.initCause(e);
            throw x;
        }
    }

    public void addCharacter(int code, int xadvance, int x, int y, int width, int height, int yoffset) {
        this.chars.add(new CharData(code, xadvance, x, y, width, height, this.size + yoffset));
    }

    public void addKerning(int first, int second, int offset) {
        this.kerning.add(new KerningData(first, second, offset));
    }

    public class KerningData {
        private int first;
        private int second;
        private int offset;

        public KerningData(int first, int second, int offset) {
            this.first = first;
            this.second = second;
            this.offset = offset;
        }
    }

    public class CharData {
        private int id;
        private int xadvance;
        private int x;
        private int y;
        private int width;
        private int height;
        private int yoffset;

        public CharData(int id, int xadvance, int x, int y, int width, int height, int yoffset) {
            this.id = id;
            this.xadvance = xadvance;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.yoffset = yoffset;
        }

        public int getID() {
            return this.id;
        }

        public int getXAdvance() {
            return this.xadvance;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getYOffset() {
            return this.yoffset;
        }
    }
}

