/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.hiero;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.Glyph;
import org.newdawn.slick.font.GlyphPage;
import org.newdawn.slick.imageout.ImageIOWriter;
import org.newdawn.slick.tools.hiero.Kerning;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class BMFontUtil {
    private final UnicodeFont unicodeFont;

    public BMFontUtil(UnicodeFont unicodeFont) {
        this.unicodeFont = unicodeFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File outputBMFontFile) throws IOException, SlickException {
        File outputDir = outputBMFontFile.getParentFile();
        String outputName = outputBMFontFile.getName();
        if (outputName.endsWith(".fnt")) {
            outputName = outputName.substring(0, outputName.length() - 4);
        }
        this.unicodeFont.loadGlyphs();
        PrintStream out = new PrintStream(new FileOutputStream(new File(outputDir, outputName + ".fnt")));
        Font font = this.unicodeFont.getFont();
        int pageWidth = this.unicodeFont.getGlyphPageWidth();
        int pageHeight = this.unicodeFont.getGlyphPageHeight();
        out.println("info face=\"" + font.getFontName() + "\" size=" + font.getSize() + " bold=" + (font.isBold() ? 1 : 0) + " italic=" + (font.isItalic() ? 1 : 0) + " charset=\"\" unicode=0 stretchH=100 smooth=1 aa=1 padding=0,0,0,0 spacing=1,1");
        out.println("common lineHeight=" + this.unicodeFont.getLineHeight() + " base=26 scaleW=" + pageWidth + " scaleH=" + pageHeight + " pages=" + this.unicodeFont.getGlyphPages().size() + " packed=0");
        int pageIndex = 0;
        int glyphCount = 0;
        Iterator pageIter = this.unicodeFont.getGlyphPages().iterator();
        while (pageIter.hasNext()) {
            GlyphPage page = (GlyphPage)pageIter.next();
            String fileName = pageIndex == 0 && !pageIter.hasNext() ? outputName + ".png" : outputName + (pageIndex + 1) + ".png";
            out.println("page id=" + pageIndex + " file=\"" + fileName + "\"");
            glyphCount += page.getGlyphs().size();
            ++pageIndex;
        }
        out.println("chars count=" + glyphCount);
        int[] glyphMetrics = this.getGlyphMetrics(font, 32);
        int xAdvance = glyphMetrics[1];
        out.println("char id=32   x=0     y=0     width=0     height=0     xoffset=0     yoffset=" + this.unicodeFont.getAscent() + "    xadvance=" + xAdvance + "     page=0  chnl=0 ");
        pageIndex = 0;
        ArrayList allGlyphs = new ArrayList(512);
        Iterator pageIter2 = this.unicodeFont.getGlyphPages().iterator();
        while (pageIter2.hasNext()) {
            GlyphPage page = (GlyphPage)pageIter2.next();
            Iterator glyphIter = page.getGlyphs().iterator();
            while (glyphIter.hasNext()) {
                Glyph glyph = (Glyph)glyphIter.next();
                glyphMetrics = this.getGlyphMetrics(font, glyph.getCodePoint());
                int xOffset = glyphMetrics[0];
                xAdvance = glyphMetrics[1];
                out.println("char id=" + glyph.getCodePoint() + "   " + "x=" + (int)(glyph.getImage().getTextureOffsetX() * (float)pageWidth) + "     y=" + (int)(glyph.getImage().getTextureOffsetY() * (float)pageHeight) + "     width=" + glyph.getWidth() + "     height=" + glyph.getHeight() + "     xoffset=" + xOffset + "     yoffset=" + glyph.getYOffset() + "    xadvance=" + xAdvance + "     page=" + pageIndex + "  chnl=0 ");
            }
            allGlyphs.addAll(page.getGlyphs());
            ++pageIndex;
        }
        String ttfFileRef = this.unicodeFont.getFontFile();
        if (ttfFileRef == null) {
            Log.warn((String)"Kerning information could not be output because a TTF font file was not specified.");
        } else {
            Kerning kerning = new Kerning();
            try {
                kerning.load(ResourceLoader.getResourceAsStream((String)ttfFileRef), font.getSize());
            }
            catch (IOException ex) {
                Log.warn((String)("Unable to read kerning information from font: " + ttfFileRef));
            }
            HashMap<Integer, Integer> glyphCodeToCodePoint = new HashMap<Integer, Integer>();
            Iterator iter = allGlyphs.iterator();
            while (iter.hasNext()) {
                Glyph glyph = (Glyph)iter.next();
                glyphCodeToCodePoint.put(new Integer(this.getGlyphCode(font, glyph.getCodePoint())), new Integer(glyph.getCodePoint()));
            }
            class KerningPair {
                public int firstCodePoint;
                public int secondCodePoint;
                public int offset;

                KerningPair() {
                }
            }
            ArrayList<KerningPair> kernings = new ArrayList<KerningPair>(256);
            Iterator iter1 = allGlyphs.iterator();
            while (iter1.hasNext()) {
                Glyph firstGlyph = (Glyph)iter1.next();
                int firstGlyphCode = this.getGlyphCode(font, firstGlyph.getCodePoint());
                int[] values = kerning.getValues(firstGlyphCode);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    Integer secondCodePoint = (Integer)glyphCodeToCodePoint.get(new Integer(values[i] & 0xFFFF));
                    if (secondCodePoint == null) continue;
                    int offset = values[i] >> 16;
                    KerningPair pair = new KerningPair();
                    pair.firstCodePoint = firstGlyph.getCodePoint();
                    pair.secondCodePoint = secondCodePoint;
                    pair.offset = offset;
                    kernings.add(pair);
                }
            }
            out.println("kernings count=" + kerning.getCount());
            Iterator iter2 = kernings.iterator();
            while (iter2.hasNext()) {
                KerningPair pair = (KerningPair)iter2.next();
                out.println("kerning first=" + pair.firstCodePoint + "  second=" + pair.secondCodePoint + "  amount=" + pair.offset);
            }
        }
        out.close();
        pageIndex = 0;
        ImageIOWriter imageWriter = new ImageIOWriter();
        Iterator pageIter3 = this.unicodeFont.getGlyphPages().iterator();
        while (pageIter3.hasNext()) {
            GlyphPage page = (GlyphPage)pageIter3.next();
            String fileName = pageIndex == 0 && !pageIter3.hasNext() ? outputName + ".png" : outputName + (pageIndex + 1) + ".png";
            File imageOutputFile = new File(outputDir, fileName);
            FileOutputStream imageOutput = new FileOutputStream(imageOutputFile);
            try {
                imageWriter.saveImage(page.getImage(), "png", (OutputStream)imageOutput, true);
            }
            finally {
                imageOutput.close();
            }
            Image image = new ImageIcon(imageOutputFile.getAbsolutePath()).getImage();
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics g = bufferedImage.getGraphics();
            g.drawImage(image, 0, 0, null);
            AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -image.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            bufferedImage = op.filter(bufferedImage, null);
            ImageIO.write((RenderedImage)bufferedImage, "png", imageOutputFile);
            ++pageIndex;
        }
    }

    private int getGlyphCode(Font font, int codePoint) {
        char[] chars = Character.toChars(codePoint);
        GlyphVector vector = font.layoutGlyphVector(GlyphPage.renderContext, chars, 0, chars.length, 0);
        return vector.getGlyphCode(0);
    }

    private int[] getGlyphMetrics(Font font, int codePoint) {
        char[] chars = Character.toChars(codePoint);
        GlyphVector vector = font.layoutGlyphVector(GlyphPage.renderContext, chars, 0, chars.length, 0);
        GlyphMetrics metrics = vector.getGlyphMetrics(0);
        int xOffset = vector.getGlyphPixelBounds((int)0, null, (float)0.0f, (float)0.0f).x - this.unicodeFont.getPaddingLeft();
        int xAdvance = (int)(metrics.getAdvanceX() + (float)this.unicodeFont.getPaddingAdvanceX() + (float)this.unicodeFont.getPaddingLeft() + (float)this.unicodeFont.getPaddingRight());
        return new int[]{xOffset, xAdvance};
    }
}

