/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.ColorPanel;
import org.newdawn.slick.tools.peditor.ControlPanel;
import org.newdawn.slick.tools.peditor.EmissionControls;
import org.newdawn.slick.tools.peditor.EmitterList;
import org.newdawn.slick.tools.peditor.GraphEditorWindow;

public class WhiskasPanel
extends ControlPanel {
    private GraphEditorWindow editor;
    private int offset = 25;
    private HashMap controlToValueName = new HashMap();
    private HashMap valueNameToControl = new HashMap();
    private HashMap valueMap = new HashMap();

    public WhiskasPanel(EmitterList l, final ColorPanel colorPanel, final EmissionControls emissionControls) {
        this.setLayout(null);
        this.setBorder(BorderFactory.createTitledBorder("Particle Life Time Gradients"));
        this.addEnableControl("Alpha", new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                colorPanel.getStartAlpha().setEnabled(e.getStateChange() != 1);
                colorPanel.getEndAlpha().setEnabled(e.getStateChange() != 1);
                WhiskasPanel.this.itemStateChangedHandler(e);
            }
        });
        this.addEnableControl("Size", new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                emissionControls.getInitialSize().setEnabledForced(e.getStateChange() != 1);
                WhiskasPanel.this.itemStateChangedHandler(e);
            }
        });
        this.addEnableControl("Velocity", new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WhiskasPanel.this.itemStateChangedHandler(e);
            }
        });
        this.addEnableControl("ScaleY", new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WhiskasPanel.this.itemStateChangedHandler(e);
            }
        });
    }

    private void addEnableControl(String text, ItemListener listener) {
        JCheckBox enableControl = new JCheckBox("Enable " + text);
        enableControl.setBounds(10, this.offset, 200, 20);
        enableControl.addItemListener(listener);
        this.add(enableControl);
        this.controlToValueName.put(enableControl, text);
        this.valueNameToControl.put(text, enableControl);
        this.offset += 25;
    }

    public void itemStateChangedHandler(ItemEvent e) {
        String valueName = (String)this.controlToValueName.get(e.getSource());
        ConfigurableEmitter.LinearInterpolator value = (ConfigurableEmitter.LinearInterpolator)this.valueMap.get(valueName);
        if (e.getStateChange() == 1) {
            value.setActive(true);
            this.editor.registerValue(value, valueName);
        } else {
            value.setActive(false);
            this.editor.removeValue(valueName);
        }
    }

    public void setEditor(GraphEditorWindow editor) {
        this.editor = editor;
    }

    protected void linkEmitterToFields(ConfigurableEmitter emitter) {
        this.emitter = emitter;
        this.editor.setLinkedEmitter(emitter);
        this.valueMap.clear();
        this.linkToEmitter("Alpha", emitter.alpha);
        this.linkToEmitter("Size", emitter.size);
        this.linkToEmitter("Velocity", emitter.velocity);
        this.linkToEmitter("ScaleY", emitter.scaleY);
        this.editor.setFirstProperty();
    }

    private void linkToEmitter(String name, ConfigurableEmitter.LinearInterpolator interpol) {
        this.valueMap.put(name, interpol);
        boolean checked = interpol.isActive();
        JCheckBox enableControl = (JCheckBox)this.valueNameToControl.get(name);
        enableControl.setSelected(false);
        if (checked) {
            enableControl.setSelected(checked);
        }
    }
}

