/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.newdawn.slick.tools.peditor.DefaultPanel;
import org.newdawn.slick.tools.peditor.InputPanelListener;

public class ValuePanel
extends DefaultPanel {
    private String name;
    private JSlider slider;
    private ArrayList listeners = new ArrayList();
    private JCheckBox linear = new JCheckBox();

    public ValuePanel(String name, int min, int max, int value, String toolTip, boolean linearEnabled) {
        this.setLayout(null);
        this.setToolTipText(toolTip);
        int offset = 0;
        if (linearEnabled) {
            JLabel label = new JLabel("Linear");
            label.setBounds(242, 15, 30, 20);
            this.add(label);
            this.linear.setBounds(245, 25, 30, 30);
            this.linear.setOpaque(false);
            this.add(this.linear);
            offset = 30;
            this.linear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ValuePanel.this.fireUpdated(e.getSource());
                }
            });
        }
        this.name = name;
        this.slider = new JSlider(min, max, value);
        this.slider.setBounds(10, 20, 260 - offset, 40);
        this.slider.setFocusable(false);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setMajorTickSpacing((max - min) / 3);
        this.slider.setMinorTickSpacing((max - min) / 10);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ValuePanel.this.fireUpdated(e.getSource());
            }
        });
        this.add(this.slider);
        this.setBorder(BorderFactory.createTitledBorder(name));
    }

    public void setLinear(boolean linear) {
        this.linear.setSelected(linear);
    }

    public boolean isLinear() {
        return this.linear.isSelected();
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void addListener(InputPanelListener listener) {
        this.listeners.add(listener);
    }

    private void fireUpdated(Object source) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((InputPanelListener)this.listeners.get(i)).valueUpdated(this);
        }
    }
}

