/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.ControlPanel;
import org.newdawn.slick.tools.peditor.DefaultPanel;
import org.newdawn.slick.tools.peditor.EmitterList;
import org.newdawn.slick.tools.peditor.ValuePanel;

public class SettingsPanel
extends ControlPanel {
    private JTextField name;
    private JTextField imageName;
    private EmitterList list;
    private JFileChooser chooser = new JFileChooser(new File("."));

    public SettingsPanel(EmitterList l) {
        this.setLayout(null);
        this.list = l;
        DefaultPanel namePanel = new DefaultPanel();
        namePanel.setBorder(BorderFactory.createTitledBorder("Emitter Name"));
        namePanel.setLayout(null);
        this.name = new JTextField();
        this.name.setBounds(10, 20, 260, 25);
        namePanel.add(this.name);
        this.name.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (SettingsPanel.this.emitter != null) {
                    SettingsPanel.this.emitter.name = SettingsPanel.this.name.getText();
                    SettingsPanel.this.list.update(SettingsPanel.this.emitter);
                }
            }
        });
        namePanel.setBounds(0, 0, 280, 55);
        this.add(namePanel);
        this.yPos += 55;
        DefaultPanel imagePanel = new DefaultPanel();
        imagePanel.setBorder(BorderFactory.createTitledBorder("Particle Image"));
        imagePanel.setLayout(null);
        this.imageName = new JTextField();
        this.imageName.setBounds(10, 20, 185, 25);
        imagePanel.add(this.imageName);
        JButton browse = new JButton("Browse");
        browse.setBounds(200, 20, 70, 25);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.browseForImage();
            }
        });
        imagePanel.add(browse);
        imagePanel.setBounds(0, 55, 280, 55);
        this.add(imagePanel);
        this.yPos += 45;
        this.addValue("gravity", new ValuePanel("Gravity", -200, 200, 0, "The gravity effect to apply", false));
        this.addValue("wind", new ValuePanel("Wind", -200, 200, 0, "The horizontal force effect to apply", false));
    }

    private void browseForImage() {
        int resp;
        if (this.emitter != null && (resp = this.chooser.showOpenDialog(this)) == 0) {
            File file = this.chooser.getSelectedFile();
            String path = file.getParentFile().getAbsolutePath();
            String name = file.getName();
            ConfigurableEmitter.setRelativePath(path);
            this.emitter.setImageName(name);
            this.imageName.setText(name);
        }
    }

    protected void linkEmitterToFields(ConfigurableEmitter emitter) {
        this.name.setText(emitter.name);
        String value = emitter.getImageName();
        if (value != null) {
            value = value.substring(value.lastIndexOf(File.separatorChar) + 1);
            this.imageName.setText(value);
        }
        this.link(emitter.gravityFactor, "gravity");
        this.link(emitter.windFactor, "wind");
    }
}

