/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GradientEditor
extends JPanel {
    private ArrayList list = new ArrayList();
    private ControlPoint selected;
    private Polygon poly = new Polygon();
    private JButton add = new JButton("Add");
    private JButton edit = new JButton("Edit");
    private JButton del = new JButton("Del");
    private int x;
    private int y;
    private int width;
    private int barHeight;
    private ArrayList listeners = new ArrayList();

    public GradientEditor() {
        this.setLayout(null);
        this.add.setBounds(20, 70, 75, 20);
        this.add(this.add);
        this.edit.setBounds(100, 70, 75, 20);
        this.add(this.edit);
        this.del.setBounds(180, 70, 75, 20);
        this.add(this.del);
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GradientEditor.this.addPoint();
            }
        });
        this.del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GradientEditor.this.delPoint();
            }
        });
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GradientEditor.this.editPoint();
            }
        });
        this.list.add(new ControlPoint(Color.white, 0.0f));
        this.list.add(new ControlPoint(Color.black, 1.0f));
        this.poly.addPoint(0, 0);
        this.poly.addPoint(5, 10);
        this.poly.addPoint(-5, 10);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GradientEditor.this.selectPoint(e.getX(), e.getY());
                GradientEditor.this.repaint(0L);
                if (e.getClickCount() == 2) {
                    GradientEditor.this.editPoint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                GradientEditor.this.movePoint(e.getX(), e.getY());
                GradientEditor.this.repaint(0L);
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireUpdate() {
        ActionEvent event = new ActionEvent(this, 0, "");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.get(i)).actionPerformed(event);
        }
    }

    private boolean checkPoint(int mx, int my, ControlPoint pt) {
        int dx = (int)Math.abs(10.0f + (float)this.width * pt.pos - (float)mx);
        int dy = Math.abs(this.y + this.barHeight + 7 - my);
        return dx < 5 && dy < 7;
    }

    private void addPoint() {
        ControlPoint point = new ControlPoint(Color.white, 0.5f);
        for (int i = 0; i < this.list.size() - 1; ++i) {
            ControlPoint now = (ControlPoint)this.list.get(i);
            ControlPoint next = (ControlPoint)this.list.get(i + 1);
            if (!(now.pos <= 0.5f) || !(next.pos >= 0.5f)) continue;
            this.list.add(i + 1, point);
            break;
        }
        this.selected = point;
        this.sortPoints();
        this.repaint(0L);
        this.fireUpdate();
    }

    private void sortPoints() {
        final ControlPoint firstPt = (ControlPoint)this.list.get(0);
        final ControlPoint lastPt = (ControlPoint)this.list.get(this.list.size() - 1);
        Comparator compare = new Comparator(){

            public int compare(Object first, Object second) {
                if (first == firstPt) {
                    return -1;
                }
                if (second == lastPt) {
                    return -1;
                }
                float a = ((ControlPoint)first).pos;
                float b = ((ControlPoint)second).pos;
                return (int)((a - b) * 10000.0f);
            }
        };
        Collections.sort(this.list, compare);
    }

    private void editPoint() {
        if (this.selected == null) {
            return;
        }
        Color col = JColorChooser.showDialog(this, "Select Color", this.selected.col);
        if (col != null) {
            this.selected.col = col;
            this.repaint(0L);
            this.fireUpdate();
        }
    }

    private void selectPoint(int mx, int my) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 1; i < this.list.size() - 1; ++i) {
            if (!this.checkPoint(mx, my, (ControlPoint)this.list.get(i))) continue;
            this.selected = (ControlPoint)this.list.get(i);
            return;
        }
        if (this.checkPoint(mx, my, (ControlPoint)this.list.get(0))) {
            this.selected = (ControlPoint)this.list.get(0);
            return;
        }
        if (this.checkPoint(mx, my, (ControlPoint)this.list.get(this.list.size() - 1))) {
            this.selected = (ControlPoint)this.list.get(this.list.size() - 1);
            return;
        }
        this.selected = null;
    }

    private void delPoint() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.selected == null) {
            return;
        }
        if (this.list.indexOf(this.selected) == 0) {
            return;
        }
        if (this.list.indexOf(this.selected) == this.list.size() - 1) {
            return;
        }
        this.list.remove(this.selected);
        this.sortPoints();
        this.repaint(0L);
        this.fireUpdate();
    }

    private void movePoint(int mx, int my) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.selected == null) {
            return;
        }
        if (this.list.indexOf(this.selected) == 0) {
            return;
        }
        if (this.list.indexOf(this.selected) == this.list.size() - 1) {
            return;
        }
        float newPos = (float)(mx - 10) / (float)this.width;
        newPos = Math.min(1.0f, newPos);
        this.selected.pos = newPos = Math.max(0.0f, newPos);
        this.sortPoints();
        this.fireUpdate();
    }

    public void paintComponent(Graphics g1d) {
        int i;
        super.paintComponent(g1d);
        Graphics2D g = (Graphics2D)g1d;
        this.width = this.getWidth() - 30;
        this.x = 10;
        this.y = 20;
        this.barHeight = 25;
        for (i = 0; i < this.list.size() - 1; ++i) {
            ControlPoint now = (ControlPoint)this.list.get(i);
            ControlPoint next = (ControlPoint)this.list.get(i + 1);
            int size = (int)((next.pos - now.pos) * (float)this.width);
            g.setPaint(new GradientPaint(this.x, this.y, now.col, this.x + size, this.y, next.col));
            g.fillRect(this.x, this.y, size + 1, this.barHeight);
            this.x += size;
        }
        g.setColor(Color.black);
        g.drawRect(10, this.y, this.width, this.barHeight - 1);
        for (i = 0; i < this.list.size(); ++i) {
            ControlPoint pt = (ControlPoint)this.list.get(i);
            g.translate(10.0f + (float)this.width * pt.pos, (double)(this.y + this.barHeight));
            g.setColor(pt.col);
            g.fillPolygon(this.poly);
            g.setColor(Color.black);
            g.drawPolygon(this.poly);
            if (pt == this.selected) {
                g.drawLine(-5, 12, 5, 12);
            }
            g.translate(-10.0f - (float)this.width * pt.pos, (double)(-this.y - this.barHeight));
        }
    }

    public void addPoint(float pos, Color col) {
        ControlPoint point = new ControlPoint(col, pos);
        for (int i = 0; i < this.list.size() - 1; ++i) {
            ControlPoint now = (ControlPoint)this.list.get(i);
            ControlPoint next = (ControlPoint)this.list.get(i + 1);
            if (!(now.pos <= 0.5f) || !(next.pos >= 0.5f)) continue;
            this.list.add(i + 1, point);
            break;
        }
        this.repaint(0L);
    }

    public void setStart(Color col) {
        ((ControlPoint)this.list.get((int)0)).col = col;
        this.repaint(0L);
    }

    public void setEnd(Color col) {
        ((ControlPoint)this.list.get((int)(this.list.size() - 1))).col = col;
        this.repaint(0L);
    }

    public void clearPoints() {
        for (int i = 1; i < this.list.size() - 1; ++i) {
            this.list.remove(1);
        }
        this.repaint(0L);
        this.fireUpdate();
    }

    public int getControlPointCount() {
        return this.list.size();
    }

    public float getPointPos(int index) {
        return ((ControlPoint)this.list.get((int)index)).pos;
    }

    public Color getColor(int index) {
        return ((ControlPoint)this.list.get((int)index)).col;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Gradient"));
        panel.setLayout(null);
        frame.setContentPane(panel);
        GradientEditor editor = new GradientEditor();
        editor.setBounds(10, 15, 270, 100);
        panel.add(editor);
        frame.setSize(300, 200);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public class ControlPoint {
        public Color col;
        public float pos;

        private ControlPoint(Color col, float pos) {
            this.col = col;
            this.pos = pos;
        }
    }
}

