/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.peditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.newdawn.slick.Color;
import org.newdawn.slick.particles.ConfigurableEmitter;
import org.newdawn.slick.tools.peditor.ControlPanel;
import org.newdawn.slick.tools.peditor.DefaultPanel;
import org.newdawn.slick.tools.peditor.GradientEditor;
import org.newdawn.slick.tools.peditor.ValuePanel;

public class ColorPanel
extends ControlPanel {
    private GradientEditor grad = new GradientEditor();
    private boolean blockUpdates = false;
    private JRadioButton inherit;
    private JRadioButton quads;
    private JRadioButton points;
    private JCheckBox oriented;
    private JCheckBox additive;
    private ValuePanel startAlpha;
    private ValuePanel endAlpha;

    public ColorPanel() {
        this.grad.setBorder(BorderFactory.createTitledBorder("Color Change"));
        this.grad.setBounds(0, 0, 280, 100);
        this.add(this.grad);
        this.grad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateColors();
            }
        });
        this.yPos += 70;
        this.startAlpha = new ValuePanel("Starting Alpha", 0, 255, 255, "The alpha value for particles at their birth", false);
        this.addValue("startAlpha", this.startAlpha);
        this.endAlpha = new ValuePanel("Ending Alpha", 0, 255, 0, "The alpha value for particles at their death", false);
        this.addValue("endAlpha", this.endAlpha);
        DefaultPanel renderingPrimitivePanel = new DefaultPanel();
        renderingPrimitivePanel.setLayout(new BoxLayout(renderingPrimitivePanel, 0));
        this.inherit = new JRadioButton("Inherit");
        this.quads = new JRadioButton("Quads");
        this.points = new JRadioButton("Points");
        ButtonGroup group = new ButtonGroup();
        group.add(this.inherit);
        group.add(this.quads);
        group.add(this.points);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateRender();
            }
        };
        this.inherit.addActionListener(al);
        this.inherit.setOpaque(false);
        this.inherit.setSelected(true);
        renderingPrimitivePanel.add(this.inherit);
        this.quads.addActionListener(al);
        this.quads.setOpaque(false);
        renderingPrimitivePanel.add(this.quads);
        this.points.addActionListener(al);
        this.points.setOpaque(false);
        renderingPrimitivePanel.add(this.points);
        renderingPrimitivePanel.setBounds(0, this.yPos + 15, 280, 45);
        this.add(renderingPrimitivePanel);
        this.yPos += 35;
        DefaultPanel renderingTypePanel = new DefaultPanel();
        renderingTypePanel.setLayout(new BoxLayout(renderingTypePanel, 0));
        this.oriented = new JCheckBox("Oriented Quad");
        this.oriented.addActionListener(al);
        this.oriented.setOpaque(false);
        renderingTypePanel.add(this.oriented);
        this.additive = new JCheckBox("Additive Blending");
        this.additive.addActionListener(al);
        this.additive.setOpaque(false);
        renderingTypePanel.add(this.additive);
        renderingTypePanel.setBounds(0, this.yPos + 15, 230, 45);
        this.add(renderingTypePanel);
        this.yPos += 35;
    }

    private void updateRender() {
        if (this.inherit.isSelected()) {
            this.emitter.usePoints = 1;
            this.oriented.setEnabled(true);
        }
        if (this.quads.isSelected()) {
            this.emitter.usePoints = 3;
            this.oriented.setEnabled(true);
        }
        if (this.points.isSelected()) {
            this.emitter.usePoints = 2;
            this.oriented.setEnabled(false);
            this.oriented.setSelected(false);
        }
        this.emitter.useOriented = this.oriented.isSelected();
        this.emitter.useAdditive = this.additive.isSelected();
    }

    private void updateColors() {
        if (this.blockUpdates) {
            return;
        }
        this.emitter.colors.clear();
        for (int i = 0; i < this.grad.getControlPointCount(); ++i) {
            float pos = this.grad.getPointPos(i);
            java.awt.Color col = this.grad.getColor(i);
            Color slick = new Color((float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f, 1.0f);
            this.emitter.addColorPoint(pos, slick);
        }
    }

    protected void linkEmitterToFields(ConfigurableEmitter emitter) {
        this.blockUpdates = true;
        this.link(emitter.startAlpha, "startAlpha");
        this.link(emitter.endAlpha, "endAlpha");
        this.grad.clearPoints();
        Color start = ((ConfigurableEmitter.ColorRecord)emitter.colors.get((int)0)).col;
        Color end = ((ConfigurableEmitter.ColorRecord)emitter.colors.get((int)(emitter.colors.size() - 1))).col;
        this.grad.setStart(new java.awt.Color(start.r, start.g, start.b, 1.0f));
        this.grad.setEnd(new java.awt.Color(end.r, end.g, end.b, 1.0f));
        for (int i = 1; i < emitter.colors.size() - 1; ++i) {
            float pos = ((ConfigurableEmitter.ColorRecord)emitter.colors.get((int)i)).pos;
            Color col = ((ConfigurableEmitter.ColorRecord)emitter.colors.get((int)i)).col;
            this.grad.addPoint(pos, new java.awt.Color(col.r, col.g, col.b, 1.0f));
        }
        this.blockUpdates = false;
        if (emitter.usePoints == 1) {
            this.inherit.setSelected(true);
        }
        if (emitter.usePoints == 2) {
            this.points.setSelected(true);
        }
        if (emitter.usePoints == 3) {
            this.quads.setSelected(true);
        }
        this.oriented.setSelected(emitter.useOriented);
        this.additive.setSelected(emitter.useAdditive);
    }

    public ValuePanel getEndAlpha() {
        return this.endAlpha;
    }

    public ValuePanel getStartAlpha() {
        return this.startAlpha;
    }
}

