/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.packulike;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.newdawn.slick.tools.packulike.Packer;
import org.newdawn.slick.tools.packulike.Sheet;
import org.newdawn.slick.tools.packulike.Sprite;

public class SheetPanel
extends JPanel {
    private Image image;
    private TexturePaint background;
    private int width;
    private int height;
    private Sheet sheet;
    private Packer packer;
    private ArrayList selected = new ArrayList();

    public SheetPanel(Packer p) {
        this.packer = p;
        Color base = Color.gray;
        BufferedImage image = new BufferedImage(50, 50, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(base);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.setColor(base.darker());
        g.fillRect(image.getWidth() / 2, 0, image.getWidth() / 2, image.getHeight() / 2);
        g.fillRect(0, image.getHeight() / 2, image.getWidth() / 2, image.getHeight() / 2);
        this.background = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Sprite sprite = SheetPanel.this.packer.getSpriteAt(e.getX(), e.getY());
                if (sprite != null) {
                    ArrayList<Sprite> selection = new ArrayList<Sprite>();
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        selection.addAll(SheetPanel.this.selected);
                    }
                    selection.add(sprite);
                    SheetPanel.this.packer.select(selection);
                }
            }
        });
    }

    public void setSelection(ArrayList sprites) {
        this.selected = sprites;
        this.repaint(0L);
    }

    public void setTextureSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(new Dimension(width, height));
        this.width = width;
        this.height = height;
    }

    public void setImage(Sheet sheet) {
        this.sheet = sheet;
        this.image = sheet.getImage();
        this.repaint(0L);
    }

    public void paint(Graphics g1d) {
        Graphics2D g = (Graphics2D)g1d;
        g.setPaint(this.background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.yellow);
        g.drawRect(0, 0, this.width, this.height);
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, null);
        }
        g.setColor(Color.green);
        for (int i = 0; i < this.selected.size(); ++i) {
            Sprite sprite = (Sprite)this.selected.get(i);
            g.drawRect(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
        }
    }
}

