/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.tools.scalar;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.newdawn.slick.tools.scalar.ImagePanel;
import org.newdawn.slick.tools.scalar.ImageScale2x;
import org.newdawn.slick.tools.scalar.ImageScale3x;

public class Scalar
extends JFrame {
    private JFileChooser loadChooser = new JFileChooser(".");
    private JFileChooser saveChooser = new JFileChooser(".");
    private ImagePanel imagePanel;
    private File lastSelected;

    public Scalar() {
        super("Scalar");
        this.saveChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".jpg")) {
                    return true;
                }
                if (f.getName().endsWith(".gif")) {
                    return true;
                }
                return f.getName().endsWith(".png");
            }

            public String getDescription() {
                return "Image files (*.png, *.jpg, *.gif)";
            }
        });
        this.loadChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".jpg")) {
                    return true;
                }
                if (f.getName().endsWith(".gif")) {
                    return true;
                }
                return f.getName().endsWith(".png");
            }

            public String getDescription() {
                return "Image files (*.png, *.jpg, *.gif)";
            }
        });
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem load = new JMenuItem("Load Image");
        JMenuItem save = new JMenuItem("Save Image");
        JMenuItem scale2x = new JMenuItem("Apply Scale2X");
        JMenuItem scale3x = new JMenuItem("Apply Scale3X");
        JMenuItem quit = new JMenuItem("Exit");
        file.add(load);
        file.add(save);
        file.addSeparator();
        file.add(scale2x);
        file.add(scale3x);
        file.addSeparator();
        file.add(quit);
        bar.add(file);
        this.setJMenuBar(bar);
        load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar.this.load();
            }
        });
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar.this.save();
            }
        });
        scale2x.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar.this.scale2x();
            }
        });
        scale3x.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar.this.scale3x();
            }
        });
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Scalar.this.quit();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.imagePanel = new ImagePanel();
        this.setContentPane(new JScrollPane(this.imagePanel));
        this.setSize(600, 600);
        Dimension dims = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dims.width - this.getWidth()) / 2, (dims.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    public void load() {
        int resp = this.loadChooser.showOpenDialog(this);
        if (resp == 0) {
            this.lastSelected = this.loadChooser.getSelectedFile();
            this.saveChooser.setCurrentDirectory(this.loadChooser.getCurrentDirectory());
            try {
                BufferedImage image = ImageIO.read(this.lastSelected);
                this.imagePanel.setImage(image);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Unable to load image " + this.lastSelected.getName() + " ");
            }
        }
    }

    public void save() {
        int resp = this.saveChooser.showSaveDialog(this);
        if (resp == 0) {
            File file = this.saveChooser.getSelectedFile();
            String type = null;
            if (file.getName().endsWith(".png")) {
                type = "PNG";
            }
            if (file.getName().endsWith(".gif")) {
                type = "GIF";
            }
            if (file.getName().endsWith(".jpg")) {
                type = "JPG";
            }
            if (type == null) {
                file = new File(file.getAbsolutePath() + ".png");
                type = "PNG";
            }
            try {
                ImageIO.write((RenderedImage)this.imagePanel.getImage(), type, file);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Unable to save file " + file.getName());
            }
        }
    }

    public void scale2x() {
        this.imagePanel.setImage(new ImageScale2x(this.imagePanel.getImage()).getScaledImage());
    }

    public void scale3x() {
        this.imagePanel.setImage(new ImageScale3x(this.imagePanel.getImage()).getScaledImage());
    }

    public void quit() {
        System.exit(0);
    }

    public static void main(String[] argv) {
        new Scalar();
    }
}

