/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;

public final class ARBShadingLanguageInclude {
    public static final int GL_SHADER_INCLUDE_ARB = 36270;
    public static final int GL_NAMED_STRING_LENGTH_ARB = 36329;
    public static final int GL_NAMED_STRING_TYPE_ARB = 36330;

    private ARBShadingLanguageInclude() {
    }

    public static void glNamedStringARB(int type, ByteBuffer name, ByteBuffer string) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name);
        BufferChecks.checkDirect(string);
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.remaining(), name, name.position(), string.remaining(), string, string.position(), function_pointer);
        Util.checkGLError();
    }

    static native void nglNamedStringARB(int var0, int var1, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, long var7);

    public static void glNamedStringARB(int type, CharSequence name, CharSequence string) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.length(), APIUtil.getBuffer(name), 0, string.length(), APIUtil.getBuffer(string, name.length()), name.length(), function_pointer);
        Util.checkGLError();
    }

    public static void glDeleteNamedStringARB(ByteBuffer name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name);
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.remaining(), name, name.position(), function_pointer);
        Util.checkGLError();
    }

    static native void nglDeleteNamedStringARB(int var0, ByteBuffer var1, int var2, long var3);

    public static void glDeleteNamedStringARB(CharSequence name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.length(), APIUtil.getBuffer(name), 0, function_pointer);
        Util.checkGLError();
    }

    public static void glCompileShaderIncludeARB(int shader, int count, ByteBuffer path) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glCompileShaderIncludeARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(path);
        BufferChecks.checkNullTerminated(path, count);
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, count, path, path.position(), null, 0, function_pointer);
        Util.checkGLError();
    }

    static native void nglCompileShaderIncludeARB(int var0, int var1, ByteBuffer var2, int var3, IntBuffer var4, int var5, long var6);

    public static void glCompileShaderIncludeARB(int shader, CharSequence[] path) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glCompileShaderIncludeARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkArray(path);
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB2(shader, path.length, APIUtil.getBuffer(path), 0, APIUtil.getLengths(path), 0, function_pointer);
        Util.checkGLError();
    }

    static native void nglCompileShaderIncludeARB2(int var0, int var1, ByteBuffer var2, int var3, IntBuffer var4, int var5, long var6);

    public static boolean glIsNamedStringARB(ByteBuffer name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glIsNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name);
        boolean __result = ARBShadingLanguageInclude.nglIsNamedStringARB(name.remaining(), name, name.position(), function_pointer);
        Util.checkGLError();
        return __result;
    }

    static native boolean nglIsNamedStringARB(int var0, ByteBuffer var1, int var2, long var3);

    public static boolean glIsNamedStringARB(CharSequence name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glIsNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        boolean __result = ARBShadingLanguageInclude.nglIsNamedStringARB(name.length(), APIUtil.getBuffer(name), 0, function_pointer);
        Util.checkGLError();
        return __result;
    }

    public static void glGetNamedStringARB(ByteBuffer name, IntBuffer stringlen, ByteBuffer string) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name);
        if (stringlen != null) {
            BufferChecks.checkBuffer(stringlen, 1);
        }
        BufferChecks.checkDirect(string);
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.remaining(), name, name.position(), string.remaining(), stringlen, stringlen != null ? stringlen.position() : 0, string, string.position(), function_pointer);
        Util.checkGLError();
    }

    static native void nglGetNamedStringARB(int var0, ByteBuffer var1, int var2, int var3, IntBuffer var4, int var5, ByteBuffer var6, int var7, long var8);

    public static void glGetNamedStringARB(CharSequence name, IntBuffer stringlen, ByteBuffer string) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (stringlen != null) {
            BufferChecks.checkBuffer(stringlen, 1);
        }
        BufferChecks.checkDirect(string);
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.length(), APIUtil.getBuffer(name), 0, string.remaining(), stringlen, stringlen != null ? stringlen.position() : 0, string, string.position(), function_pointer);
        Util.checkGLError();
    }

    public static String glGetNamedStringARB(CharSequence name, int bufSize) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetNamedStringARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer string_length = APIUtil.getLengths();
        ByteBuffer string = APIUtil.getBufferByte(bufSize + name.length());
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.length(), APIUtil.getBuffer(name), 0, bufSize, string_length, 0, string, string.position(), function_pointer);
        Util.checkGLError();
        string.limit(name.length() + string_length.get(0));
        return APIUtil.getString(string);
    }

    public static void glGetNamedStringARB(ByteBuffer name, int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetNamedStringivARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(name);
        BufferChecks.checkBuffer(params, 1);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.remaining(), name, name.position(), pname, params, params.position(), function_pointer);
        Util.checkGLError();
    }

    static native void nglGetNamedStringivARB(int var0, ByteBuffer var1, int var2, int var3, IntBuffer var4, int var5, long var6);

    public static void glGetNamedStringiARB(CharSequence name, int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetNamedStringivARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(params, 1);
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.length(), APIUtil.getBuffer(name), 0, pname, params, params.position(), function_pointer);
        Util.checkGLError();
    }

    public static int glGetNamedStringiARB(CharSequence name, int pname) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetNamedStringivARB;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer params = APIUtil.getBufferInt();
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.length(), APIUtil.getBuffer(name), 0, pname, params, params.position(), function_pointer);
        Util.checkGLError();
        return params.get(0);
    }
}

