import java.util.LinkedList;
import java.util.List;

public class Company {

    private String name;
    private List<StaffMember> staffMembers;

    public Company(String name) {
        this.name = name;
        this.staffMembers = new LinkedList<>();
    }

    public void addMember(StaffMember staffMember) {
        this.staffMembers.add(staffMember);
    }

    public void payday() {
        System.out.println("Company: " + this.name);
        for (StaffMember staffMember : this.staffMembers) {
            try {
                double pay = staffMember.pay();
                System.out.println(staffMember.getName() + " - " + (pay == 0.0 ? "Thank you" : pay));
            }
            catch (NoPaydayPolicyException e) {
                System.out.println(staffMember.getName() + " - " + "No payday policy is set");
            }
        }
    }
}
