import java.util.ArrayList;
import java.util.Collection;

public class Main {

    public static void main(String[] args) {

        // Create article stock

        Collection<Article> stock = new ArrayList();

        // Add articles to the stock

        stock.add(new Article("Bread", 20, 1.4));
        stock.add(new Article("Milk", 0, 1.8));
        stock.add(new Article("Egg", 50, 0.2));
        stock.add(new Article("Cheese", 0, 5.1));
        stock.add(new Article("Beer", 30, 1.4));

        // Calculate stock value
        
        double stockValue = stock.stream()  // Get stream
                .filter(article -> article.getQuantity() > 0)  // Filter only positive stock quantity
                .mapToDouble(article -> article.getQuantity() * article.getPrice())  // Calculate stock value for an article
                .sum();  // Sum stock values of the articles

        System.out.println("Stock value is " + stockValue);
    }
}
