import java.util.List;

public class Shop {

    private String name;

    private List<Article> articles;

    private double turnover;

    public Shop(String name, List<Article> articles) {
        this.name = name;
        this.articles = articles;
        this.turnover = 0.0;
    }

    public void sell(Article article) {
        article.update(-1);
        this.turnover += article.getPrice();
    }

    public double getTurnover() {
        return this.turnover;
    }

    @Override
    public String toString() {
        return getClass().getName() + ": name = " + this.name + ", turnover = " + this.turnover;
    }
}
