import java.util.LinkedList;
import java.util.List;

public class Main {

    public static void main(String[] args) {

        // Create article

        Article bread = new Article("Bread", 100, 1.5);
        System.out.println(bread + " - created");

        // Add articles to a list

        List<Article> articles = new LinkedList();
        articles.add(bread);

        // Create shop

        Shop grocery = new Shop("Grocery", articles);
        System.out.println(grocery + " - created");

        // Sell article three times with three different price calculation defined by lambda

        int basketCounter = 0;

        // Sell with no price calculation (use default price)
        grocery.sell(bread);
        System.out.println(bread + " - sold");
        basketCounter++;

        // Sell with 20 % discount
        bread.setPriceCalculation(price -> price * 0.8);
        grocery.sell(bread);
        System.out.println(bread + " - sold");
        basketCounter++;

        // Sell with 0.00 price when 2 or more articles are in basket
        int finalBasketCounter = basketCounter;  // We need to use final of effectively final variable
        bread.setPriceCalculation(price -> {
            if (finalBasketCounter < 2)
                return price;
            return 0.0;
        });
        grocery.sell(bread);
        System.out.println(bread + " - sold");
        basketCounter++;

        // Print turnover

        System.out.println("Total turnover: " + grocery.getTurnover());
    }
}
