public class Article {

    private static int counter = 0;

    private int id;

    private String name;

    private int quantity;

    private double price;

    private PriceCalculation priceCalculation;

    public Article(String name, int quantity, double price) {
        this.id = ++counter;
        this.name = name;
        this.quantity = quantity;
        this.price = price;
        this.priceCalculation = p -> p;
    }

    public void update(int quantity) {
        this.quantity += quantity;
    }

    public double getPrice() {
        return this.priceCalculation.calculate(this.price);
    }

    public void setPriceCalculation(PriceCalculation priceCalculation) {
        if (priceCalculation == null)
            return;
        this.priceCalculation = priceCalculation;
    }

    @Override
    public String toString() {
        return getClass().getName() + ": id = " + this.id + ", name = " + this.name + ", quantity = " + this.quantity + ", price = " + this.price;
    }
}
