import java.util.Arrays;
import java.util.List;

public class Main {

    private static int shift = 1;

    public static void main(String[] args) {

        // List of three integers: 1, 2, and 3
        List<Integer> intSeq = Arrays.asList(1, 2, 3);

        // Simple lambda expression
        intSeq.forEach(x -> System.out.println(x));

        // Multiline lambda expression
        intSeq.forEach(x -> {
            x += 2;
            System.out.println(x);
        });

        // Lambda expression with local variable
        intSeq.forEach(x -> {
            int y = x * 2;
            System.out.println(y);
        });

        // Lambda expression with declared parameter type
        intSeq.forEach((Integer x) -> {
            x += 2;
            System.out.println(x);
        });

        // Variable capture - local variable vs. static variable

        int mult = 2;

        intSeq.forEach(x -> {
            shift = 10;  // Static variable can be changed in lambda expression

            // Local variable cannot be changed
            // mult = 3;

            // Local variable must be final or effectively final when used in lambda
            System.out.println(x * mult + shift);
        });

        // Local varible is not effectively final when it is changed after lambda is defined
        // mult = 4;
        
        // Lambda expression as reference to static function
        intSeq.forEach(Main::f);
    }

    private static void f(Integer x) {
        System.out.println(x);
    }
}