import java.lang.reflect.Array;

public class Container<T> {

    private T[] items;
    private int size;
    private int index;

    public Container(Class<T> c, int maxSize) {
        this.items = (T[]) Array.newInstance(c, maxSize);  // Use reflection to create new instance of an array T[]
        this.size = 0;
        this.index = 0;
    }

    public void add(T item) {
        if (this.size < this.items.length)
            this.items[this.size++] = item;
    }

    public T first() {
        this.index = -1;
        return next();
    }

    public T next() {
        this.index++;
        if (hasNext())
            return this.items[this.index];
        else {
            this.index = this.size;
            return null;
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }
}
