public class StringContainer implements Container<String> {

    private String[] items;
    private int size;
    private int index;

    public StringContainer(int maxSize) {
        this.items = new String[maxSize];
        this.size = 0;
        this.index = 0;
    }

    @Override
    public void add(String item) {
        if (this.size < this.items.length)
            this.items[this.size++] = item;
    }

    @Override
    public String first() {
        this.index = -1;
        return next();
    }

    @Override
    public String next() {
        this.index++;
        if (hasNext())
            return this.items[this.index];
        else {
            this.index = this.size;
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }
}
