public class Article {

    private static int counter = 0;

    private int id;
    
    private String name;
    
    private int quantity;
    
    private double price;
    
    private PricePolicy pricePolicy;

    public Article(String name, int quantity, double price) {
        this.id = ++counter;
        this.name = name;
        this.quantity = quantity;
        this.price = price;
        this.pricePolicy = new PricePolicy();
    }

    public void update(int quantity) {
        this.quantity += quantity;
    }

    public double getPrice() {
        return pricePolicy.getPrice(this.price);
    }

    public void setPricePolicy(PricePolicy pricePolicy) {
        if (pricePolicy == null)
            return;
        this.pricePolicy = pricePolicy;
    }

    @Override
    public String toString() {
        return getClass().getName() + ": id = " + this.id + ", name = " + this.name + ", quantity = " + this.quantity + ", price = " + this.price;
    }
}
