﻿using System.Collections.Generic;

namespace Shop_cs
{
    public class Shop
    {
        private string Name { get; set; }

        private IList<Article> Articles { get; set; }

        public double Turnover { get; private set; }

        public Shop(string name, IList<Article> articles)
        {
            Name = name;
            Articles = articles;
            Turnover = 0.0;
        }

        public void Sell(Article article)
        {
            article.Update(-1);
            Turnover += article.Price;
        }
    }
}
