<#-- @ftlvariable name="errors" type="java.lang.String[]" -->
<#-- @ftlvariable name="retryLink" type="String" -->
<!DOCTYPE HTML>

<html lang="en">
<head>
    <title>Arena IDE: Successful Login</title>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no"/>
    <style>
        @import "https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400";
        @import "https://fonts.googleapis.com/css?family=Cinzel:400,700";

        html, body {
            margin: 0;
            padding: 0;
        }

        body {
            background-color: #d0a388;
            background-image: linear-gradient(-45deg, #d0a388 15%, #a24314 85%);
            font-family: "Source Sans Pro", "sans-serif";
            font-weight: lighter;
            font-size: 24px;
            min-height: 100vh;
            color: white;
        }

        b {
            font-weight: normal;
        }

        h1 {
            font-family: "Cinzel", "serif";
            font-weight: normal;
            font-size: 48px;
        }

        a, a:visited, a:active {
            color: white;
            text-decoration: #a24314 underline;
        }

        .container {
            padding: 24px;
        }
    </style>
</head>
<body>
<section class="container">
    <h1>Arena IDE</h1>

    <p>Login to Arena failed.</p>

    <#if errors??>
        <p>
            Errors:
        <ul>
            <#list errors as error>
                <li>${error}</li>
            </#list>
        </ul>
        </p>
    </#if>

    <hr/>

    <p>
        <a href="${retryLink}" target="_self">Retry login</a>
    </p>
</section>
</body>
</html>
