/*
 * Decompiled with CFR 0.152.
 */
package com.github.kittinunf.fuel.core;

import com.github.kittinunf.fuel.core.BlobDataPart;
import com.github.kittinunf.fuel.core.DataPart;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J=\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\b\u0010!\u001a\u00020\"H\u0016J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/github/kittinunf/fuel/core/FileDataPart;", "Lcom/github/kittinunf/fuel/core/DataPart;", "file", "Ljava/io/File;", "name", "", "filename", "contentType", "contentDisposition", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getContentDisposition", "()Ljava/lang/String;", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getContentType", "getFile", "()Ljava/io/File;", "getFilename", "getName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "inputStream", "Ljava/io/FileInputStream;", "toString", "Companion", "fuel"})
public final class FileDataPart
extends DataPart {
    @NotNull
    private final File file;
    @NotNull
    private final String name;
    @Nullable
    private final String filename;
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentDisposition;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public FileInputStream inputStream() {
        File file = this.file;
        boolean bl = false;
        return new FileInputStream(file);
    }

    @Override
    @NotNull
    public Long getContentLength() {
        return this.file.length();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getFilename() {
        return this.filename;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public FileDataPart(@NotNull File file, @NotNull String name, @Nullable String filename, @NotNull String contentType, @NotNull String contentDisposition) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contentDisposition, (String)"contentDisposition");
        super(null);
        this.file = file;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentDisposition = contentDisposition;
    }

    public /* synthetic */ FileDataPart(File file, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = FilesKt.getNameWithoutExtension((File)file);
        }
        if ((n & 4) != 0) {
            string2 = file.getName();
        }
        if ((n & 8) != 0) {
            string3 = Companion.guessContentType(file);
        }
        if ((n & 0x10) != 0) {
            string4 = "form-data; name=\"" + string + '\"' + (string2 != null ? "; filename=\"" + string2 + '\"' : "");
        }
        this(file, string, string2, string3, string4);
    }

    @NotNull
    public final File component1() {
        return this.file;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @Nullable
    public final String component3() {
        return this.filename;
    }

    @NotNull
    public final String component4() {
        return this.getContentType();
    }

    @NotNull
    public final String component5() {
        return this.getContentDisposition();
    }

    @NotNull
    public final FileDataPart copy(@NotNull File file, @NotNull String name, @Nullable String filename, @NotNull String contentType, @NotNull String contentDisposition) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contentDisposition, (String)"contentDisposition");
        return new FileDataPart(file, name, filename, contentType, contentDisposition);
    }

    public static /* synthetic */ FileDataPart copy$default(FileDataPart fileDataPart, File file, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            file = fileDataPart.file;
        }
        if ((n & 2) != 0) {
            string = fileDataPart.name;
        }
        if ((n & 4) != 0) {
            string2 = fileDataPart.filename;
        }
        if ((n & 8) != 0) {
            string3 = fileDataPart.getContentType();
        }
        if ((n & 0x10) != 0) {
            string4 = fileDataPart.getContentDisposition();
        }
        return fileDataPart.copy(file, string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "FileDataPart(file=" + this.file + ", name=" + this.name + ", filename=" + this.filename + ", contentType=" + this.getContentType() + ", contentDisposition=" + this.getContentDisposition() + ")";
    }

    public int hashCode() {
        File file = this.file;
        String string = this.name;
        String string2 = this.filename;
        String string3 = this.getContentType();
        String string4 = this.getContentDisposition();
        return ((((file != null ? ((Object)file).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FileDataPart)) break block3;
                FileDataPart fileDataPart = (FileDataPart)object;
                if (!Intrinsics.areEqual((Object)this.file, (Object)fileDataPart.file) || !Intrinsics.areEqual((Object)this.name, (Object)fileDataPart.name) || !Intrinsics.areEqual((Object)this.filename, (Object)fileDataPart.filename) || !Intrinsics.areEqual((Object)this.getContentType(), (Object)fileDataPart.getContentType()) || !Intrinsics.areEqual((Object)this.getContentDisposition(), (Object)fileDataPart.getContentDisposition())) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\bJ:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\bJ2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/github/kittinunf/fuel/core/FileDataPart$Companion;", "", "()V", "from", "Lcom/github/kittinunf/fuel/core/DataPart;", "directory", "Ljava/io/File;", "filename", "", "name", "remoteFileName", "contentType", "path", "guessContentType", "file", "fuel"})
    public static final class Companion {
        @NotNull
        public final String guessContentType(@NotNull File file) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                String string = URLConnection.guessContentTypeFromName(file.getName());
                if (string == null) {
                    object = file;
                    boolean bl = false;
                    string = BlobDataPart.Companion.guessContentType(new FileInputStream((File)object));
                }
                object = string;
            }
            catch (NoClassDefFoundError ex) {
                object = "application/octet-stream";
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DataPart from(@NotNull String path, @Nullable String remoteFileName, @Nullable String name, @Nullable String contentType) {
            String string;
            String string2;
            File file;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File file2 = file = new File(path);
            String string3 = name;
            if (string3 == null) {
                string3 = FilesKt.getNameWithoutExtension((File)file);
            }
            String string4 = remoteFileName;
            if (string4 != null) {
                void it;
                String string5 = string4;
                boolean bl = false;
                boolean bl2 = false;
                String string6 = string5;
                String string7 = string3;
                File file3 = file2;
                boolean bl3 = false;
                String string8 = StringsKt.isBlank((CharSequence)((CharSequence)it)) ? file.getName() : it;
                file2 = file3;
                string3 = string7;
                string2 = string8;
            } else {
                string2 = null;
            }
            if ((string = contentType) == null) {
                string = this.guessContentType(file);
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            String string9 = null;
            String string10 = string;
            String string11 = string2;
            String string12 = string3;
            File file4 = file2;
            return new FileDataPart(file4, string12, string11, string10, string9, n, defaultConstructorMarker);
        }

        public static /* synthetic */ DataPart from$default(Companion companion, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            return companion.from(string, string2, string3, string4);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final DataPart from(@NotNull String directory, @NotNull String filename, @Nullable String name, @Nullable String remoteFileName, @Nullable String contentType) {
            DataPart dataPart;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            if (new File(directory).isFile()) {
                CharSequence charSequence = remoteFileName;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    dataPart = this.from(directory, filename, name, contentType);
                    return dataPart;
                }
            }
            dataPart = this.from(new File(directory), filename, name, remoteFileName, contentType);
            return dataPart;
        }

        public static /* synthetic */ DataPart from$default(Companion companion, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            return companion.from(string, string2, string3, string4, string5);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DataPart from(@Nullable File directory, @NotNull String filename, @Nullable String name, @Nullable String remoteFileName, @Nullable String contentType) {
            String string;
            String string2;
            File file;
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            File file2 = file = new File(directory, filename);
            String string3 = name;
            if (string3 == null) {
                string3 = FilesKt.getNameWithoutExtension((File)file);
            }
            String string4 = remoteFileName;
            if (string4 != null) {
                void it;
                String string5 = string4;
                boolean bl = false;
                boolean bl2 = false;
                String string6 = string5;
                String string7 = string3;
                File file3 = file2;
                boolean bl3 = false;
                String string8 = StringsKt.isBlank((CharSequence)((CharSequence)it)) ? filename : it;
                file2 = file3;
                string3 = string7;
                string2 = string8;
            } else {
                string2 = null;
            }
            if ((string = contentType) == null) {
                string = this.guessContentType(file);
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            String string9 = null;
            String string10 = string;
            String string11 = string2;
            String string12 = string3;
            File file4 = file2;
            return new FileDataPart(file4, string12, string11, string10, string9, n, defaultConstructorMarker);
        }

        public static /* synthetic */ DataPart from$default(Companion companion, File file, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = "";
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            return companion.from(file, string, string2, string3, string4);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

