/*
 * Decompiled with CFR 0.152.
 */
package sk.tuke.kpi.arena.intellij.ui.project;

import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.time.Duration;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sk.tuke.kpi.arena.intellij.spartan.Round;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ8\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lsk/tuke/kpi/arena/intellij/ui/project/ArenaProjectRenderer;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lsk/tuke/kpi/arena/intellij/spartan/Round;", "()V", "info", "Ljavax/swing/JLabel;", "kotlin.jvm.PlatformType", "infoCell", "Ljava/awt/GridBagConstraints;", "name", "nameCell", "getListBackground", "Ljava/awt/Color;", "isSelected", "", "hasFocus", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "cellHasFocus", "getListForeground", "initConstraints", "", "layoutComponents", "intellij-arena"})
final class ArenaProjectRenderer
extends JPanel
implements ListCellRenderer<Round> {
    @NotNull
    private final JLabel name = new JLabel();
    private final JLabel info = ComponentPanelBuilder.createNonWrappingCommentComponent((String)"");
    @NotNull
    private GridBagConstraints nameCell = new GridBagConstraints();
    @NotNull
    private GridBagConstraints infoCell = new GridBagConstraints();

    public ArenaProjectRenderer() {
        super(new GridBagLayout());
        this.setFocusable(true);
        this.initConstraints();
        this.layoutComponents();
    }

    private final void layoutComponents() {
        this.add((Component)this.name, this.nameCell);
        this.add((Component)this.info, this.infoCell);
    }

    private final void initConstraints() {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints $this$initConstraints_u24lambda_u2d0 = gridBagConstraints = this.nameCell;
        boolean bl = false;
        $this$initConstraints_u24lambda_u2d0.gridx = 0;
        $this$initConstraints_u24lambda_u2d0.gridy = 0;
        $this$initConstraints_u24lambda_u2d0.weightx = 1.0;
        $this$initConstraints_u24lambda_u2d0.weighty = 1.0;
        $this$initConstraints_u24lambda_u2d0.anchor = 23;
        $this$initConstraints_u24lambda_u2d0.insets = (Insets)JBUI.insets((int)6, (int)5, (int)1, (int)5);
        GridBagConstraints $this$initConstraints_u24lambda_u2d1 = gridBagConstraints = this.infoCell;
        boolean bl2 = false;
        $this$initConstraints_u24lambda_u2d1.gridx = 0;
        $this$initConstraints_u24lambda_u2d1.gridy = 1;
        $this$initConstraints_u24lambda_u2d1.insets = (Insets)JBUI.insets((int)1, (int)5, (int)6, (int)5);
        $this$initConstraints_u24lambda_u2d1.anchor = 25;
    }

    @NotNull
    public final Color getListBackground(boolean isSelected, boolean hasFocus) {
        Color color;
        if (isSelected) {
            Color color2 = WelcomeScreenUIManager.getProjectsSelectionBackground((boolean)hasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getProjectsSelectionBackground(hasFocus)");
            color = color2;
        } else {
            Color color3 = WelcomeScreenUIManager.getProjectsBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getProjectsBackground()");
            color = color3;
        }
        return color;
    }

    @NotNull
    public final Color getListForeground(boolean isSelected, boolean hasFocus) {
        Color color = WelcomeScreenUIManager.getProjectsSelectionForeground((boolean)isSelected, (boolean)hasFocus);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getProjectsSelectionFore\u2026und(isSelected, hasFocus)");
        return color;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends Round> list, @NotNull Round value, int index, boolean isSelected, boolean cellHasFocus) {
        void $this$getListCellRendererComponent_u24lambda_u2d3;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Color fg = this.getListForeground(isSelected, list.hasFocus());
        Color bg = this.getListBackground(isSelected, list.hasFocus());
        this.name.setForeground(fg);
        this.info.setForeground(UIUtil.getInactiveTextColor());
        this.setBackground(bg);
        this.name.setText(value.getTitle());
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        JLabel jLabel = this.info;
        boolean bl = false;
        Duration $this$getListCellRendererComponent_u24lambda_u2d3_u24lambda_u2d2 = value.getDuration();
        boolean bl2 = false;
        String duration = (String)($this$getListCellRendererComponent_u24lambda_u2d3_u24lambda_u2d2.toHours() > 0L ? $this$getListCellRendererComponent_u24lambda_u2d3_u24lambda_u2d2.toHours() + "h" : "") + " " + $this$getListCellRendererComponent_u24lambda_u2d3_u24lambda_u2d2.minusHours($this$getListCellRendererComponent_u24lambda_u2d3_u24lambda_u2d2.toHours()).toMinutes() + "m";
        $this$getListCellRendererComponent_u24lambda_u2d3.append("duration: " + duration);
        String date = DateFormat.getInstance().format(value.getActiveUntil());
        $this$getListCellRendererComponent_u24lambda_u2d3.append(" | available until " + date);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        jLabel.setText(string);
        return this;
    }
}

