/*
 * Decompiled with CFR 0.152.
 */
package sk.tuke.kpi.arena.intellij.submission;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.BalloonImpl;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sk.tuke.kpi.arena.intellij.extensions.openapi.ApplicationKt;
import sk.tuke.kpi.arena.intellij.project.ArenaProject;
import sk.tuke.kpi.arena.intellij.project.ArenaProjectKt;
import sk.tuke.kpi.arena.intellij.spartan.ProblemSet;
import sk.tuke.kpi.arena.intellij.submission.SubmissionService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsk/tuke/kpi/arena/intellij/submission/LastSubmissionNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "autoSubmitCountdown", "Ljava/time/Duration;", "getAutoSubmitCountdown", "()Ljava/time/Duration;", "autoSubmitTime", "Ljava/time/Instant;", "message", "", "getMessage", "()Ljava/lang/String;", "state", "Lsk/tuke/kpi/arena/intellij/submission/LastSubmissionNotification$State;", "updater", "Ljava/util/concurrent/ScheduledFuture;", "doSubmit", "", "startUpdater", "Companion", "State", "intellij-arena"})
public final class LastSubmissionNotification
extends Notification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private State state;
    @NotNull
    private final Instant autoSubmitTime;
    @NotNull
    private final ScheduledFuture<?> updater;
    @NotNull
    private static final String LAST_SUBMISSION_MESSAGE_GROUP = "ArenaProject-lastSubmission";
    private static final long LAST_SUBMISSION_DELAY = 15L;

    public LastSubmissionNotification(@NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(LAST_SUBMISSION_MESSAGE_GROUP, null, NotificationType.INFORMATION);
        this.project = project;
        this.state = State.AUTO;
        Instant instant = Instant.now().plusSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().plusSeconds(LAST_SUBMISSION_DELAY)");
        this.autoSubmitTime = instant;
        this.updater = this.startUpdater();
        NotificationsConfiguration.getNotificationsConfiguration().register(LAST_SUBMISSION_MESSAGE_GROUP, NotificationDisplayType.STICKY_BALLOON, false);
        ArenaProject arenaProject2 = ArenaProjectKt.getArenaProject(this.project);
        if (arenaProject2 == null) {
            string = null;
        } else {
            ProblemSet problemSet = arenaProject2.getProblemSet();
            string = problemSet == null ? null : problemSet.getTitle();
        }
        this.setTitle("Arena project <i>" + string + "</i> just expired");
        this.setContent(this.getMessage());
        this.addAction((AnAction)new DumbAware(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                state = State.DECIDED;
                this.expire();
                this.doSubmit();
            }
        });
        this.addAction((AnAction)new DumbAware(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                state = State.DECIDED;
                ArenaProject arenaProject2 = ArenaProjectKt.getArenaProject(project);
                if (arenaProject2 != null) {
                    arenaProject2.setState(ArenaProject.State.FINISHED);
                }
                this.expire();
            }
        });
        this.setImportant(true);
    }

    private final Duration getAutoSubmitCountdown() {
        Duration duration = Duration.ofMillis(this.autoSubmitTime.toEpochMilli() - Instant.now().toEpochMilli());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(autoSubmitTime.\u2026ant.now().toEpochMilli())");
        return duration;
    }

    private final String getMessage() {
        return "One last submission will be automatically submitted in <b>" + this.getAutoSubmitCountdown().getSeconds() + "s</b>";
    }

    private final ScheduledFuture<?> startUpdater() {
        return ApplicationKt.scheduleWithFixedDelay$default(1L, 0L, TimeUnit.SECONDS, (Function0)new Function0<Unit>(this){
            final /* synthetic */ LastSubmissionNotification this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                if (LastSubmissionNotification.access$getState$p(this.this$0) == State.DECIDED) {
                    LastSubmissionNotification.access$getUpdater$p(this.this$0).cancel(false);
                    this.this$0.expire();
                } else if (LastSubmissionNotification.access$getAutoSubmitTime$p(this.this$0).isBefore(Instant.now())) {
                    LastSubmissionNotification.access$getUpdater$p(this.this$0).cancel(false);
                    this.this$0.expire();
                    LastSubmissionNotification.access$doSubmit(this.this$0);
                } else {
                    BalloonImpl balloonImpl;
                    Object object = this.this$0.getBalloon();
                    BalloonImpl balloonImpl2 = balloonImpl = object instanceof BalloonImpl ? (BalloonImpl)object : null;
                    if (balloonImpl != null) {
                        void $this$filterIsInstanceTo$iv$iv;
                        BalloonImpl it = balloonImpl;
                        boolean bl = false;
                        JBTreeTraverser jBTreeTraverser = UIUtil.uiTraverser((Component)it.getContent());
                        Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"uiTraverser(it.content)");
                        Iterable $this$filterIsInstance$iv = (Iterable)jBTreeTraverser;
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof JEditorPane)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = (JEditorPane)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                        if (object != null) {
                            Object object2 = object;
                            LastSubmissionNotification lastSubmissionNotification = this.this$0;
                            Object it2 = object2;
                            boolean bl2 = false;
                            ((JEditorPane)it2).setText(LastSubmissionNotification.access$getMessage(lastSubmissionNotification));
                        }
                    }
                }
            }
        }, 2, null);
    }

    private final void doSubmit() {
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ LastSubmissionNotification this$0;
            {
                this.this$0 = lastSubmissionNotification;
            }

            public final void run() {
                boolean bl = false;
                if (!LastSubmissionNotification.access$getProject$p(this.this$0).isDisposed()) {
                    Project $this$service$iv = LastSubmissionNotification.access$getProject$p(this.this$0);
                    boolean $i$f$service = false;
                    Object object = $this$service$iv.getService(SubmissionService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    ((SubmissionService)object).submit(true);
                }
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    public static final /* synthetic */ State access$getState$p(LastSubmissionNotification $this) {
        return $this.state;
    }

    public static final /* synthetic */ ScheduledFuture access$getUpdater$p(LastSubmissionNotification $this) {
        return $this.updater;
    }

    public static final /* synthetic */ Instant access$getAutoSubmitTime$p(LastSubmissionNotification $this) {
        return $this.autoSubmitTime;
    }

    public static final /* synthetic */ String access$getMessage(LastSubmissionNotification $this) {
        return $this.getMessage();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lsk/tuke/kpi/arena/intellij/submission/LastSubmissionNotification$State;", "", "(Ljava/lang/String;I)V", "AUTO", "DECIDED", "intellij-arena"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State AUTO = new State();
        public static final /* enum */ State DECIDED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.AUTO, State.DECIDED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lsk/tuke/kpi/arena/intellij/submission/LastSubmissionNotification$Companion;", "", "()V", "LAST_SUBMISSION_DELAY", "", "LAST_SUBMISSION_MESSAGE_GROUP", "", "intellij-arena"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

