/*
 * Decompiled with CFR 0.152.
 */
package sk.tuke.kpi.arena.intellij.project;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sk.tuke.kpi.arena.intellij.login.ArenaSession;
import sk.tuke.kpi.arena.intellij.project.ArenaProjectKt;
import sk.tuke.kpi.arena.intellij.ui.close.CloseDialog;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lsk/tuke/kpi/arena/intellij/project/ArenaProjectClosingListener;", "Lcom/intellij/openapi/project/VetoableProjectManagerListener;", "Lcom/intellij/openapi/project/impl/ProjectLifecycleListener;", "()V", "ASKED_ABOUT_CLOSING", "Lcom/intellij/openapi/util/Key;", "", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "projectsDirsToDelete", "", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "activate", "", "canClose", "project", "projectClosed", "scheduleDeleteAfterClose", "intellij-arena"})
public final class ArenaProjectClosingListener
implements VetoableProjectManagerListener,
ProjectLifecycleListener {
    @NotNull
    public static final ArenaProjectClosingListener INSTANCE = new ArenaProjectClosingListener();
    @NotNull
    private static final Key<Boolean> ASKED_ABOUT_CLOSING;
    @NotNull
    private static final Map<Project, VirtualFile> projectsDirsToDelete;
    @NotNull
    private static AtomicBoolean isActive;

    private ArenaProjectClosingListener() {
    }

    public final void activate() {
        if (isActive.compareAndSet(false, true)) {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectLifecycleListener.TOPIC, (Object)this);
            ProjectManager.getInstance().addProjectManagerListener((VetoableProjectManagerListener)this);
        }
    }

    public boolean canClose(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ArenaProjectKt.isArenaProject(project) && !Intrinsics.areEqual((Object)project.getUserData(ASKED_ABOUT_CLOSING), (Object)true)) {
            CloseDialog closeDialog = new CloseDialog(project);
            if (!closeDialog.showAndGet()) {
                return false;
            }
            project.putUserData(ASKED_ABOUT_CLOSING, (Object)true);
            if (closeDialog.getShouldDeleteProject()) {
                VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
                if (virtualFile != null) {
                    String string = virtualFile.getPath();
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        RecentProjectsManager.getInstance().removePath(it);
                    }
                }
                this.scheduleDeleteAfterClose(project);
            }
            boolean $i$f$service = false;
            Class<ArenaSession> serviceClass$iv = ArenaSession.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            ((ArenaSession)object).logoutCompletely();
        }
        return true;
    }

    public void projectClosed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = projectsDirsToDelete.remove(project);
        if (virtualFile == null) {
            return;
        }
        VirtualFile baseDir = virtualFile;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(baseDir, this){
            final /* synthetic */ VirtualFile $baseDir$inlined;
            final /* synthetic */ ArenaProjectClosingListener this$0;
            {
                this.$baseDir$inlined = virtualFile;
                this.this$0 = arenaProjectClosingListener;
            }

            public final T compute() {
                boolean bl = false;
                this.$baseDir$inlined.delete((Object)this.this$0);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void scheduleDeleteAfterClose(Project project) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            projectsDirsToDelete.put(project, it);
        }
    }

    static {
        Key key = Key.create((String)"arena.askedWhetherToCloseProject");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"arena.askedWhetherToCloseProject\")");
        ASKED_ABOUT_CLOSING = key;
        projectsDirsToDelete = new ConcurrentHashMap();
        isActive = new AtomicBoolean(false);
    }
}

