/*
 * Decompiled with CFR 0.152.
 */
package sk.tuke.kpi.arena.intellij.common;

import com.github.kittinunf.fuel.core.FuelError;
import com.github.kittinunf.fuel.core.HttpException;
import com.github.kittinunf.result.Result;
import com.github.kittinunf.result.ResultKt;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sk.tuke.kpi.arena.intellij.common.BadRequestError;
import sk.tuke.kpi.arena.intellij.common.ConnectionError;
import sk.tuke.kpi.arena.intellij.common.ServerError;
import sk.tuke.kpi.arena.intellij.common.ServerErrorKt;
import sk.tuke.kpi.arena.intellij.common.UnauthorizedError;
import sk.tuke.kpi.arena.intellij.common.UnknownError;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a6\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u0002H\u0006`\u0007\"\b\b\u0000\u0010\u0006*\u00020\b*\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0003*(\u0010\n\u001a\u0004\b\u0000\u0010\u0006\"\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a8\u0006\u000b"}, d2={"convertFuelToArenaServerError", "Lsk/tuke/kpi/arena/intellij/common/ServerError;", "fuelError", "Lcom/github/kittinunf/fuel/core/FuelError;", "mapArenaServerError", "Lcom/github/kittinunf/result/Result;", "V", "Lsk/tuke/kpi/arena/intellij/common/ServerResult;", "", "toArenaServerError", "ServerResult", "intellij-arena"})
public final class ServerErrorKt {
    private static final ServerError convertFuelToArenaServerError(FuelError fuelError) {
        ServerError serverError;
        Throwable throwable = fuelError.getException();
        if (throwable instanceof SocketException) {
            serverError = new ConnectionError("Server is unavailable");
        } else if (throwable instanceof HttpException) {
            switch (fuelError.getResponse().getStatusCode()) {
                case 403: {
                    serverError = new UnauthorizedError("Invalid credentials");
                    break;
                }
                case 400: {
                    serverError = new BadRequestError("Bad request");
                    break;
                }
                default: {
                    serverError = new UnknownError();
                    break;
                }
            }
        } else {
            serverError = new UnknownError();
        }
        return serverError;
    }

    @NotNull
    public static final ServerError toArenaServerError(@NotNull FuelError $this$toArenaServerError) {
        Intrinsics.checkNotNullParameter((Object)$this$toArenaServerError, (String)"<this>");
        return ServerErrorKt.convertFuelToArenaServerError($this$toArenaServerError);
    }

    @NotNull
    public static final <V> Result<V, ServerError> mapArenaServerError(@NotNull Result<? extends V, ? extends FuelError> $this$mapArenaServerError) {
        Intrinsics.checkNotNullParameter($this$mapArenaServerError, (String)"<this>");
        return ResultKt.mapError($this$mapArenaServerError, (Function1)mapArenaServerError.1.INSTANCE);
    }

    public static final /* synthetic */ ServerError access$convertFuelToArenaServerError(FuelError fuelError) {
        return ServerErrorKt.convertFuelToArenaServerError(fuelError);
    }
}

