/*
 * Decompiled with CFR 0.152.
 */
package sk.tuke.kpi.arena.intellij.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.ResourceConverter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sk.tuke.kpi.arena.intellij.common.JsonApiKt;
import sk.tuke.kpi.arena.intellij.common.RelationshipLinkage;
import sk.tuke.kpi.arena.intellij.common.ResourceLinkage;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\"\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tJ1\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u0002H\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0017\"\b\b\u0000\u0010\u000e*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\bH\u0016J4\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00130\u0017\"\b\b\u0000\u0010\u000e*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lsk/tuke/kpi/arena/intellij/common/ArenaResourceConverter;", "Lcom/github/jasminb/jsonapi/ResourceConverter;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "baseUrl", "", "classes", "", "Ljava/lang/Class;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/String;[Ljava/lang/Class;)V", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "processRelationshipLinkage", "", "T", "obj", "json", "Lcom/fasterxml/jackson/databind/JsonNode;", "relationshipIdFields", "", "Ljava/lang/reflect/Field;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/databind/JsonNode;Ljava/util/List;)V", "readDocument", "Lcom/github/jasminb/jsonapi/JSONAPIDocument;", "", "dataStream", "Ljava/io/InputStream;", "clazz", "readDocumentCollection", "intellij-arena"})
public final class ArenaResourceConverter
extends ResourceConverter {
    @NotNull
    private final ObjectMapper objectMapper;

    public ArenaResourceConverter(@NotNull ObjectMapper objectMapper, @Nullable String baseUrl, Class<?> ... classes) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        super(objectMapper, baseUrl, (Class[])Arrays.copyOf(classes, classes.length));
        this.objectMapper = objectMapper;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public <T> JSONAPIDocument<T> readDocument(@NotNull InputStream dataStream, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        byte[] inputData = ByteStreamsKt.readBytes((InputStream)dataStream);
        JSONAPIDocument document = super.readDocument((InputStream)new ByteArrayInputStream(inputData), clazz);
        List relationshipIdFields = JsonApiKt.getAnnotatedFields$default(clazz, Reflection.getOrCreateKotlinClass(RelationshipLinkage.class), false, 2, null);
        if (document.getErrors() != null || relationshipIdFields.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            return document;
        }
        JsonNode jsonObject = this.objectMapper.readTree((InputStream)new ByteArrayInputStream(inputData));
        Object object = document.get();
        if (object == null) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            return document;
        }
        Object documentData = object;
        JsonNode jsonNode = jsonObject.get("data");
        if (jsonNode == null) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            return document;
        }
        JsonNode jsonData = jsonNode;
        this.processRelationshipLinkage(documentData, jsonData, relationshipIdFields);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        return document;
    }

    @NotNull
    public <T> JSONAPIDocument<List<T>> readDocumentCollection(@NotNull InputStream dataStream, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        byte[] inputData = ByteStreamsKt.readBytes((InputStream)dataStream);
        JSONAPIDocument document = super.readDocumentCollection((InputStream)new ByteArrayInputStream(inputData), clazz);
        List relationshipIdFields = JsonApiKt.getAnnotatedFields$default(clazz, Reflection.getOrCreateKotlinClass(RelationshipLinkage.class), false, 2, null);
        if (document.getErrors() != null || relationshipIdFields.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            return document;
        }
        JsonNode jsonObject = this.objectMapper.readTree((InputStream)new ByteArrayInputStream(inputData));
        List list = (List)document.get();
        if (list == null) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            return document;
        }
        List documentData = list;
        JsonNode jsonNode = jsonObject.get("data");
        if (jsonNode == null) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            return document;
        }
        JsonNode jsonData = jsonNode;
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)documentData, (Iterable)((Iterable)jsonData));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$obj$json = (Pair)element$iv;
            boolean bl = false;
            Object obj = $dstr$obj$json.component1();
            JsonNode json = (JsonNode)$dstr$obj$json.component2();
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            this.processRelationshipLinkage(obj, json, relationshipIdFields);
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        return document;
    }

    private final <T> void processRelationshipLinkage(T obj, JsonNode json, List<Field> relationshipIdFields) {
        JsonNode jsonRelationships = json.get("relationships");
        for (Field field : relationshipIdFields) {
            JsonNode jsonRel;
            String relName = field.getAnnotation(RelationshipLinkage.class).value();
            JsonNode jsonNode = jsonRelationships.get(relName);
            if ((jsonNode == null ? null : jsonNode.get("data")) == null) continue;
            jsonRel = jsonRel;
            String string = jsonRel.get("id").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonRel[ID].asText()");
            String string2 = string;
            string = jsonRel.get("type").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonRel.get(TYPE).asText()");
            field.set(obj, new ResourceLinkage(string2, string));
        }
    }
}

