/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.ErrorUtils;
import com.github.jasminb.jsonapi.exceptions.InvalidJsonApiResourceException;
import com.github.jasminb.jsonapi.exceptions.ResourceParseException;
import com.github.jasminb.jsonapi.models.errors.Errors;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void ensureValidDocument(ObjectMapper mapper, JsonNode resourceNode) {
        if (resourceNode == null || resourceNode.isNull()) {
            throw new InvalidJsonApiResourceException();
        }
        boolean hasErrors = resourceNode.hasNonNull("errors");
        boolean hasData = resourceNode.has("data");
        boolean hasMeta = resourceNode.has("meta");
        if (hasErrors) {
            try {
                throw new ResourceParseException(ErrorUtils.parseError(mapper, resourceNode, Errors.class));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        if (!hasData && !hasMeta) {
            throw new InvalidJsonApiResourceException();
        }
    }

    public static void ensurePrimaryDataValidArray(JsonNode dataNode) {
        if (!ValidationUtils.isArrayOfResourceObjects(dataNode) && !ValidationUtils.isArrayOfResourceIdentifierObjects(dataNode)) {
            throw new InvalidJsonApiResourceException("Primary data must be an array of resource objects, an array of resource identifier objects, or an empty array ([])");
        }
    }

    public static void ensurePrimaryDataValidObjectOrNull(JsonNode dataNode) {
        if (!ValidationUtils.isValidObject(dataNode) && ValidationUtils.isNotNullNode(dataNode)) {
            throw new InvalidJsonApiResourceException("Primary data must be either a single resource object, a single resource identifier object, or null");
        }
    }

    public static void ensureValidResourceObjectArray(JsonNode dataNode) {
        if (!ValidationUtils.isArrayOfResourceObjects(dataNode)) {
            throw new InvalidJsonApiResourceException("Included must be an array of valid resource objects, or an empty array ([])");
        }
    }

    public static boolean isNotNullNode(JsonNode dataNode) {
        return dataNode != null && !dataNode.isNull();
    }

    public static boolean isValidObject(JsonNode dataNode) {
        return ValidationUtils.isResourceObject(dataNode) || ValidationUtils.isResourceIdentifierObject(dataNode);
    }

    public static boolean isResourceIdentifierObject(JsonNode dataNode) {
        return dataNode != null && dataNode.isObject() && ValidationUtils.hasValueNode(dataNode, "id") && ValidationUtils.hasValueNode(dataNode, "type") && ValidationUtils.hasContainerOrNull(dataNode, "meta");
    }

    public static boolean isResourceObject(JsonNode dataNode) {
        return dataNode != null && dataNode.isObject() && ValidationUtils.hasValueOrNull(dataNode, "id") && ValidationUtils.hasValueNode(dataNode, "type") && ValidationUtils.hasContainerOrNull(dataNode, "meta") && ValidationUtils.hasContainerNode(dataNode, "attributes") && ValidationUtils.hasContainerOrNull(dataNode, "links") && ValidationUtils.hasContainerOrNull(dataNode, "relationships");
    }

    public static boolean isArrayOfResourceObjects(JsonNode dataNode) {
        if (dataNode != null && dataNode.isArray()) {
            for (JsonNode element : dataNode) {
                if (ValidationUtils.isResourceObject(element) || ValidationUtils.isResourceIdentifierObject(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isArrayOfResourceIdentifierObjects(JsonNode dataNode) {
        if (dataNode != null && dataNode.isArray()) {
            for (JsonNode element : dataNode) {
                if (ValidationUtils.isResourceIdentifierObject(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean hasContainerNode(JsonNode dataNode, String attribute) {
        return dataNode.hasNonNull(attribute) && dataNode.get(attribute).isContainerNode();
    }

    private static boolean hasValueNode(JsonNode dataNode, String attribute) {
        return dataNode.hasNonNull(attribute) && dataNode.get(attribute).isValueNode();
    }

    private static boolean hasContainerOrNull(JsonNode dataNode, String attribute) {
        if (dataNode.hasNonNull(attribute)) {
            return dataNode.get(attribute).isContainerNode();
        }
        return true;
    }

    private static boolean hasValueOrNull(JsonNode dataNode, String attribute) {
        if (dataNode.hasNonNull(attribute)) {
            return dataNode.get(attribute).isValueNode();
        }
        return true;
    }
}

