public class StaffMember {

    private String name;
    private double salary;
    private PaydayPolicy paydayPolicy;

    public StaffMember(String name, double salary) {
        this.name = name;
        this.salary = salary;
        this.paydayPolicy = null;
    }

    public String getName() {
        return this.name;
    }

    public double getSalary() {
        return this.salary;
    }

    public PaydayPolicy getPaydayPolicy() {
        return this.paydayPolicy;
    }

    public void setPaydayPolicy(PaydayPolicy paydayPolicy) {
        this.paydayPolicy = paydayPolicy;
    }

    public double pay() throws NoPaydayPolicyException {
        if (this.paydayPolicy == null)
            throw new NoPaydayPolicyException();
        return paydayPolicy.pay(this.salary);
    }
}
