public class Container {

    private Object[] items;
    private int size;
    private int index;

    public Container(int maxSize) {
        this.items = new Object[maxSize];
        this.size = 0;
        this.index = 0;
    }

    public void add(Object item) {
        if (this.size < this.items.length)
            this.items[this.size++] = item;
    }

    public Object first() {
        this.index = -1;
        return next();
    }

    public Object next() {
        this.index++;
        if (hasNext())
            return this.items[this.index];
        else {
            this.index = this.size;
            return null;
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }
}
