public class IntegerContainer implements Container<Integer> {

    private Integer[] items;
    private int size;
    private int index;

    public IntegerContainer(int maxSize) {
        this.items = new Integer[maxSize];
        this.size = 0;
        this.index = 0;
    }

    @Override
    public void add(Integer item) {
        if (this.size < this.items.length)
            this.items[this.size++] = item;
    }

    @Override
    public Integer first() {
        this.index = -1;
        return next();
    }

    @Override
    public Integer next() {
        this.index++;
        if (hasNext())
            return this.items[this.index];
        else {
            this.index = this.size;
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }
}
