import java.util.LinkedList;
import java.util.List;

public class Main {

    public static void main (String[] args) {

        // Create a lion and a butterfly
        Lion simba = new Lion("Simba");
        Butterfly emanuel = new Butterfly("Emanuel");

        // Polymorphic reference to an animal
        Animal animal = simba; // Works well because Animal is polymorphic to Lion
        animal = emanuel;  // Works well because Animal is polymorphic to Butterfly

        // Let's use List<T> as a type for a cage and LinkedList<> for implementation of a cage

        // Create cage for lions and put there a lion
        List<Lion> lionCage = new LinkedList<>();
        lionCage.add(simba);

        // Create cage for butterflies and put there a butterfly
        List<Butterfly> butterflyCage = new LinkedList<>();
        butterflyCage.add(emanuel);

        // Create all-animal cage and put any animals there
        List<Animal> animalCage = new LinkedList<>();
        animalCage.add(simba);
        animalCage.add(emanuel);

        // Let's play with polymorphic animal cage

        // Error !!! Incompatible types List<Animal> and List<Lion> are not polymorphic !!!
        //  List<Animal> someCage = lionCage;

        // Error !!! Incompatible types List<Animal> and List<Butterfly> are not polymorphic !!!
        // List<Animal> someCage = butterflyCage;

        List<? extends Animal> someCage = lionCage;  // Works well because List<? extends Animal> is polymorphic to List<Lion>
        someCage = butterflyCage;  // Works well because List<? extends Animal> is polymorphic to List<Butterfly>

        // Error !!! Polymorphic animal cage cannot be used to add animals !!!
        // someCage.add(emanuel);

        // Feed animals using various cages, also polymorphic cage can be used
        feedAnimals(lionCage);
        feedAnimals(butterflyCage);
        feedAnimals(animalCage);
        feedAnimals(someCage);

    }

    // Generic method accepting any types of cages
    private static void feedAnimals(List<? extends Animal> someCage) {
        for (Animal animal : someCage)
            animal.feedMe();
    }
}
