public class Boat implements Movable {

    private int speed;

    public Boat() {
        this.speed = 0;
    }

    @Override
    public void forward() {
        if (this.speed == 0)
            System.out.println("Boat cannot move, the speed is " + this.speed);
        else
            System.out.println("Boat sails forward at speed " + this.speed);
    }

    @Override
    public void backward() {
        if (this.speed == 0)
            System.out.println("Boat cannot move, the speed is " + this.speed);
        else
            System.out.println("Boat sails backward at speed " + this.speed);
    }

    @Override
    public void left() {
        if (this.speed == 0)
            System.out.println("Boat cannot move, the speed is " + this.speed);
        else
            System.out.println("Boat sails left at speed " + this.speed);
    }

    @Override
    public void right() {
        if (this.speed == 0)
            System.out.println("Boat cannot move, the speed is " + this.speed);
        else
            System.out.println("Boat sails right at speed " + this.speed);
    }

    @Override
    public void climb() {
        System.out.println("Boat cannot climb!");
    }

    @Override
    public void dive() {
        System.out.println("Boat cannot dive!");
    }

    @Override
    public void setSpeed(int speed) {
        if (speed < 0)
            System.out.println("Wrong number!");
        else if (speed > MAX_SPEED)
            System.out.println("Boat cannot move faster than " + MAX_SPEED);
        else {
            this.speed = speed;
            System.out.println("Boat speed is set to " + this.speed);
        }
    }
}
