import java.util.LinkedList;
import java.util.List;

public class Main {

    public static void main(String[] args) {

        // Create articles

        Article bread = new Article("Bread", 100, 1.5);
        System.out.println("Article Bread (id: " + bread.getId() + ", quantity: 100, price: 1.50) was created.");

        Article milk = new Article("Milk", 150, 2.0);
        System.out.println("Article Milk (id: " + milk.getId() + ", quantity: 150, price: 2.00) was created.");

        Article unknown = new Article();
        System.out.println("Article Unknown (id: " + unknown.getId() + ", quantity: 0, price: 0.00) was created.");

        Article butter = new DiscountArticle("Butter", 50, 3.0, 0.2);
        System.out.println("DiscountArticle Butter (id: " + butter.getId() + ", quantity: 50, price: 3.00, discount: 20 %) was created.");

        // Add articles to a list

        List<Article> articles = new LinkedList<>();
        articles.add(bread);
        articles.add(milk);
        articles.add(unknown);
        articles.add(butter);

        // Create shop
        Shop grocery = new Shop("Grocery", articles);
        System.out.println("Shop Grocery (articles: Bread, Milk, Unknown, Butter) was created.");

        // Sell articles

        grocery.sell(bread);
        System.out.println("One bread was sold.");

        grocery.sell(milk);
        System.out.println("One milk was sold.");

        grocery.sell(unknown);
        System.out.println("One unknown was sold.");

        grocery.sell(butter);
        System.out.println("One butter was sold.");

        // Print turnover

        System.out.println("Total turnover: " + grocery.getTurnover());
    }
}
