import java.util.LinkedList;
import java.util.List;

public class Main {

    public static void main(String[] args) {

        // Create articles

        Article bread = new Article("Bread", 100, 1.5);
        System.out.println(bread + " - created");

        Article milk = new Article("Milk", 150, 2.0);
        System.out.println(milk + " - created");

        Article butter = new Article("Butter", 50, 3.0);
        System.out.println(butter + " - created");

        // Set price policies (discounts)

        milk.setPricePolicy(new AmountDiscount(0.5));

        butter.setPricePolicy(new PercentageDiscount(0.2));

        // Add articles to a list

        List<Article> articles = new LinkedList();
        articles.add(bread);
        articles.add(milk);
        articles.add(butter);

        // Create shop

        Shop grocery = new Shop("Grocery", articles);
        System.out.println(grocery + " - created");

        // Sell articles

        grocery.sell(bread);
        System.out.println(bread + " - sold");

        grocery.sell(milk);
        System.out.println(milk + " - sold");

        grocery.sell(butter);
        System.out.println(butter + " - sold");

        // Print turnover

        System.out.println("Total turnover: " + grocery.getTurnover());
    }
}
