// created on Jan 20, 2013

/**
 * @author Niam
 */

    long gcd_val(long k, long m) {
        long r;

        while (m != 0) {
            r = k % m;
            k = m;
            m = r;
        }
        // At this point, GCD(K,M) = GCD(k,m) = GCD(k,0) = k
        return k;
   }

    // OpenCL Kernel Function for matrix computation
    kernel void MatrixStepForm( global const long* nums, 
                                global const long* dens, 
                                global long* c, 
                                global long* d, 
                                global const long* actualRowNum, 
                                global const long* actualRowDen, 
                                int row, 
                                int column) {
        //buffer nums: array of numerators of the input matrix
        //buffer dens: array of denominators of the input matrix
        //buffer c: array of numerators of the output matrix, results of computation
        //buffer c: array of denominators of the output matrix, results of computation
        //buffer actualRowNum: array of numerators of the previous row
        //buffer actualRowDen: array of denominators of the previous row
        
        // get index into global data array
        const int iGID = get_global_id(0);
        
        if (iGID >= row * column)  {
            return;
        }


        //actual column in previous actualRow
        long aRN = actualRowNum[iGID % column];
        long aRD = actualRowDen[iGID % column];
        
        //alphas
        long an = nums[(iGID / column) * column];
        long ad = dens[(iGID / column) * column];

        //aRN * alpha
        long a = aRN * an;
        long b = aRD * ad;

        //substitute rational numbers
        long num = (nums[iGID] * b) - (dens[iGID] * a);
        long den = dens[iGID] * b;
        
        //calculate GCD and write the reduced numbers into buffers
        long gcd = gcd_val(num, den);
        c[iGID] = num / gcd;
        d[iGID] = den / gcd;
    }
