// created on Jan 20, 2013

/**
 * @author Niam
 */

    // OpenCL Kernel Function for matrix computation
    kernel void MatrixStepForm( global const float* input, 
                                global float* result, 
                                global const float* actualRow, 
                                int row, 
                                int column) {
        //buffer nums: array of numerators of the input matrix
        //buffer dens: array of denominators of the input matrix
        //buffer c: array of numerators of the output matrix, results of computation
        //buffer c: array of denominators of the output matrix, results of computation
        //buffer actualRowNum: array of numerators of the previous row
        //buffer actualRowDen: array of denominators of the previous row
        
        // get index into global data array
        const int iGID = get_global_id(0);
        
        if (iGID >= row * column)  {
            return;
        }

        //actual column in previous actualRow
        float aR = actualRow[iGID % column];
       
        float alpha = input[(iGID / column) * column];
        //ad = dens[(iGID / column) * column];

        //substitute
        result[iGID] = input[iGID] - (aR * alpha);  
    }
