/*
 * Decompiled with CFR 0.152.
 */
package test;

import LESSolver.LESSolverImpl;
import LESSolver.Matrix;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;
import test.Results;

public class TestSLR {
    private static int[][] matica;
    private static int[] vektor;
    public static boolean gpu;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -2;
        nArray[2] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 4;
        nArray2[2] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 6;
        nArray3[2] = -1;
        nArrayArray[2] = nArray3;
        matica = nArrayArray;
        vektor = new int[3];
        gpu = false;
    }

    public static void main(String[] args) throws Exception {
        int size = 150;
        LESSolverImpl lss = new LESSolverImpl();
        PrintWriter out = new PrintWriter(new FileWriter("test_results.txt"));
        PrintWriter stat = new PrintWriter(new FileWriter("table_results.txt"));
        PrintWriter exc = new PrintWriter(new FileWriter("exc_results.txt"));
        int[] excel = new int[3 * (size - 10)];
        int i = 10;
        while (i < size) {
            int time2;
            int[][] mat = TestSLR.generate(i, i);
            int[] vec = TestSLR.generateVector(i);
            Matrix matrix = new Matrix(mat, vec);
            out.println("Matrix:\n" + matrix.getM() + " x " + matrix.getN());
            String s = lss.solve(mat, vec).toString().replaceAll("<br>", "\n").replaceAll("<b>", "").replaceAll("</b>", "");
            out.println(s);
            int time1 = Integer.valueOf(s.substring(s.indexOf("took:") + 6, s.indexOf("\u00c2\u00b5") - 1));
            if (i < 25) {
                s = lss.solveGPU(mat, vec).toString().replaceAll("<br>", "\n").replaceAll("<b>", "").replaceAll("</b>", "");
                out.println(s);
                time2 = s.contains("range") ? 0 : Integer.valueOf(s.substring(s.indexOf("took:") + 6, s.indexOf("\u00c2\u00b5") - 1));
            } else {
                time2 = 0;
            }
            s = lss.solveGPUReal(mat, vec).toString().replaceAll("<br>", "\n").replaceAll("<b>", "").replaceAll("</b>", "");
            out.println(s);
            int time3 = Integer.valueOf(s.substring(s.indexOf("took:") + 6, s.indexOf("\u00c2\u00b5") - 1));
            Results res = new Results(i, time1, time2, time3);
            stat.println(String.valueOf(i) + ",     " + time1 + ",     " + time2 + ",     " + time3);
            excel[i - 10] = i;
            excel[i - 10 + (size - 10)] = time1;
            excel[i - 10 + (size - 10) * 2] = time3;
            System.out.println(i);
            ++i;
        }
        i = 0;
        while (i < excel.length) {
            exc.println(excel[i]);
            ++i;
        }
        stat.close();
        out.close();
        exc.close();
    }

    private static int[][] generate(int x, int y) {
        int[][] ret = new int[x][y];
        Random rn = new Random();
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                ret[i][j] = rn.nextInt(2);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private static int[] generateVector(int x) {
        int[] ret = new int[x];
        Random rn = new Random();
        int i = 0;
        while (i < x) {
            ret[i] = rn.nextInt(5);
            ++i;
        }
        return ret;
    }
}

