/*
 * Decompiled with CFR 0.152.
 */
package LESSolver;

import LESSolver.BigRational;
import LESSolver.ILESSolution;
import LESSolver.LESSolution;
import LESSolver.Matrix;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public class SystemOfEquations {
    private int rankA;
    private int rankAb;
    List<Integer> parameters;
    private Matrix system;
    public boolean verbose = false;
    public boolean gpu = false;
    private ArrayList<BigRational> x;
    private ArrayList<BigRational> v;
    private ArrayList<BigRational>[] p;
    private LESSolution solution;
    long nt;

    public SystemOfEquations(Matrix A) {
        System.out.println("konstruktor 1");
        this.system = A;
        this.solution = new LESSolution();
    }

    public SystemOfEquations(Matrix A, boolean gpu) {
        this.system = A;
        this.solution = new LESSolution();
        this.gpu = gpu;
    }

    private int toStepFormGPU() {
        StringBuilder log = new StringBuilder("Uprava systemu na stupnovity tvar:\n\n");
        CLContext context = null;
        CLDevice device = null;
        CLCommandQueue queue = null;
        CLProgram program = null;
        long gpu_time = 0L;
        long conversion_time = 0L;
        context = CLContext.create();
        if (this.verbose) {
            System.out.println("created " + context);
        }
        if (this.verbose) {
            CLDevice[] devices;
            CLDevice[] cLDeviceArray = devices = context.getDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                CLDevice d = cLDeviceArray[n2];
                System.out.println("\n" + d);
                System.out.println("Vendor: " + d.getVendor());
                System.out.println("Global Memory: " + d.getGlobalMemSize() / 1000000L + " MB");
                System.out.println("Local Memory: " + d.getLocalMemSize() / 1000L + " KB");
                System.out.println("Driver: " + d.getDriverVersion());
                System.out.println("Frequency: " + d.getMaxClockFrequency());
                System.out.println("Max Unit Comupute: " + d.getMaxComputeUnits());
                System.out.println("Max Global Work Size: " + d.getMaxWorkGroupSize());
                ++n2;
            }
        }
        CLDevice cLDevice = device = context.getMaxFlopsDevice(CLDevice.Type.GPU) != null ? context.getMaxFlopsDevice(CLDevice.Type.GPU) : context.getMaxFlopsDevice();
        if (this.verbose) {
            System.out.println("LESSolver computing on " + device.getName() + "\nGPGPU mode...");
        }
        queue = device.createCommandQueue();
        try {
            program = context.createProgram(new InputStream[]{SystemOfEquations.class.getResourceAsStream("Kernel.cl")}).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int column = -1;
        boolean flag = false;
        int row = 0;
        while (row < this.system.getM()) {
            if (++column > this.system.getN() - 2) {
                return 1;
            }
            if (flag) {
                flag = false;
            }
            int max = --row;
            int i = row + 1;
            while (i < this.system.getM()) {
                if (BigRational.abs(this.system.data[i][column]).compareTo(BigRational.abs(this.system.data[max][column])) > 0) {
                    max = i;
                }
                ++i;
            }
            BigRational[] temp = this.system.data[row];
            this.system.data[row] = this.system.data[max];
            this.system.data[max] = temp;
            if (BigRational.abs(this.system.data[row][column]).compareTo(BigRational.ZERO) == 0) {
                flag = true;
            } else {
                BigRational alpha = this.system.data[row][column];
                int i2 = column;
                while (i2 < this.system.getN()) {
                    this.system.data[row][i2] = this.system.data[row][i2].divides(alpha);
                    ++i2;
                }
                int elementCount = (this.system.getM() - (row + 1)) * (this.system.getN() - column);
                if (elementCount != 0) {
                    int localWorkSize = device.getMaxWorkGroupSize() < 256 ? device.getMaxWorkGroupSize() : 256;
                    int globalWorkSize = SystemOfEquations.roundUp(localWorkSize, elementCount);
                    CLBuffer clBufferA = context.createLongBuffer(elementCount, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                    CLBuffer clBufferB = context.createLongBuffer(elementCount, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                    CLBuffer clBufferC = context.createLongBuffer(elementCount, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
                    CLBuffer clBufferD = context.createLongBuffer(elementCount, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
                    CLBuffer actualRowNum = context.createLongBuffer(this.system.getN() - column, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                    CLBuffer actualRowDen = context.createLongBuffer(this.system.getN() - column, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                    i2 = row + 1;
                    while (i2 < this.system.getM()) {
                        int j = column;
                        while (j < this.system.getN()) {
                            ((LongBuffer)clBufferA.getBuffer()).put(this.system.data[i2][j].getNum().longValue());
                            ((LongBuffer)clBufferB.getBuffer()).put(this.system.data[i2][j].getDen().longValue());
                            if (this.system.data[i2][j].getDen().longValue() > 8000000000000000000L) {
                                return -1;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    int j = column;
                    while (j < this.system.getN()) {
                        ((LongBuffer)actualRowNum.getBuffer()).put(this.system.data[row][j].getNum().longValue());
                        ((LongBuffer)actualRowDen.getBuffer()).put(this.system.data[row][j].getDen().longValue());
                        ++j;
                    }
                    ((LongBuffer)clBufferA.getBuffer()).rewind();
                    ((LongBuffer)clBufferB.getBuffer()).rewind();
                    ((LongBuffer)actualRowDen.getBuffer()).rewind();
                    ((LongBuffer)actualRowNum.getBuffer()).rewind();
                    CLKernel kernel = program.createCLKernel("MatrixStepForm");
                    kernel.putArgs(new CLMemory[]{clBufferA, clBufferB, clBufferC, clBufferD, actualRowNum, actualRowDen}).putArg(this.system.getM() - (row + 1)).putArg(this.system.getN() - column);
                    queue.putWriteBuffer(clBufferA, true);
                    queue.putWriteBuffer(clBufferB, true);
                    queue.putWriteBuffer(actualRowNum, true);
                    queue.putWriteBuffer(actualRowDen, true);
                    long nt = System.nanoTime();
                    queue.put1DRangeKernel(kernel, 0L, (long)globalWorkSize, (long)localWorkSize);
                    queue.putReadBuffer(clBufferC, false);
                    queue.putReadBuffer(clBufferD, false);
                    gpu_time += System.nanoTime() - nt;
                    int i3 = 0;
                    while (i3 < this.system.getM() - (row + 1)) {
                        int j2 = 0;
                        while (j2 < this.system.getN() - column) {
                            int col = this.system.getN() - column;
                            this.system.data[i3 + row + 1][j2 + column].setNum(BigInteger.valueOf(((LongBuffer)clBufferC.getBuffer()).get(i3 * col + j2)));
                            this.system.data[i3 + row + 1][j2 + column].setDen(BigInteger.valueOf(((LongBuffer)clBufferD.getBuffer()).get(i3 * col + j2)));
                            ++j2;
                        }
                        ++i3;
                    }
                    clBufferA.release();
                    clBufferB.release();
                    clBufferC.release();
                    clBufferD.release();
                    actualRowDen.release();
                    actualRowNum.release();
                    if (this.verbose) {
                        System.out.println("used device memory: " + (clBufferA.getCLSize() + clBufferB.getCLSize() + clBufferC.getCLSize() + clBufferD.getCLSize() + actualRowDen.getCLSize() + actualRowNum.getCLSize()) / 1000L + "KB");
                    }
                }
            }
            ++row;
        }
        context.release();
        this.nt = gpu_time;
        if (this.verbose) {
            System.out.println("GPU computation took: " + gpu_time / 1000L + " us");
            System.out.println(log.toString());
        }
        return 1;
    }

    private void toStepForm() {
        StringBuilder log = new StringBuilder("Uprava systemu na stupnovity tvar:\n\n");
        log.append(this.system.print(this.system.getM(), this.system.getN()));
        int column = -1;
        boolean flag = false;
        int row = 0;
        while (row < this.system.getM()) {
            if (++column > this.system.getN() - 2) {
                return;
            }
            if (flag) {
                flag = false;
            }
            int max = --row;
            int i = row + 1;
            while (i < this.system.getM()) {
                if (BigRational.abs(this.system.data[i][column]).compareTo(BigRational.abs(this.system.data[max][column])) > 0) {
                    max = i;
                }
                ++i;
            }
            BigRational[] temp = this.system.data[row];
            this.system.data[row] = this.system.data[max];
            this.system.data[max] = temp;
            if (BigRational.abs(this.system.data[row][column]).compareTo(BigRational.ZERO) == 0) {
                flag = true;
            } else {
                BigRational alpha = this.system.data[row][column];
                int i2 = column;
                while (i2 < this.system.getN()) {
                    this.system.data[row][i2] = this.system.data[row][i2].divides(alpha);
                    ++i2;
                }
                long time = System.nanoTime();
                int i3 = row + 1;
                while (i3 < this.system.getM()) {
                    alpha = this.system.data[i3][column];
                    int j = column;
                    while (j < this.system.getN()) {
                        this.system.data[i3][j] = this.system.data[i3][j].minus(this.system.data[row][j].times(alpha));
                        ++j;
                    }
                    ++i3;
                }
                this.nt += System.nanoTime() - time;
                log.append(this.system.print(this.system.getM(), this.system.getN()));
            }
            ++row;
        }
        if (this.verbose) {
            System.out.println(log.toString());
        }
    }

    private boolean setRanks() {
        int zeroRowsA = 0;
        int zeroRowsAb = 0;
        int m = this.system.getM() - 1;
        while (m >= 0) {
            int n = 0;
            while (n < this.system.getN()) {
                if (BigRational.abs(this.system.data[m][n]).compareTo(BigRational.ZERO) != 0) break;
                if (n == this.system.getN() - 2) {
                    ++zeroRowsA;
                }
                if (n == this.system.getN() - 1) {
                    ++zeroRowsAb;
                }
                ++n;
            }
            if (BigRational.abs(this.system.data[m][this.system.getN() - 2]).compareTo(BigRational.ZERO) != 0) break;
            --m;
        }
        this.rankA = this.system.getM() - zeroRowsA;
        this.rankAb = this.system.getM() - zeroRowsAb;
        return this.rankAb == this.rankA;
    }

    public ILESSolution solve() {
        if (this.gpu) {
            if (this.toStepFormGPU() == -1) {
                this.solution.textSolution = new StringBuilder("Rational number out of range");
                this.solution.solution = null;
                return this.solution;
            }
        } else {
            this.toStepForm();
        }
        if (this.setRanks()) {
            if (this.findParameters(this.rankAb) == 0) {
                this.solveSquare(this.rankAb);
            } else {
                this.solveRectangular(this.rankAb);
            }
        } else {
            this.solution.textSolution.append("System nema riesenie.");
            this.solution.solution = null;
        }
        this.solution.textSolution.append("<br><br>The computation took: <b>" + this.nt / 1000L + " \u00c2\u00b5s</b><br><br>");
        return this.solution;
    }

    private int findParameters(int m) {
        this.parameters = new ArrayList<Integer>();
        int j = 0;
        int i = 0;
        while (i < m) {
            if (BigRational.abs(this.system.data[i][j]).compareTo(BigRational.ZERO) == 0) {
                this.parameters.add(j);
                --i;
            }
            ++j;
            ++i;
        }
        while (j < this.system.getN() - 1) {
            this.parameters.add(j);
            ++j;
        }
        return this.parameters.size();
    }

    private void toIdentity(int m) {
        int stlpec = this.system.getN() - 2;
        int i = m - 1;
        while (i > 0) {
            int k = i;
            while (k > 0) {
                while (this.parameters.contains(stlpec)) {
                    --stlpec;
                }
                BigRational alpha = this.system.data[k - 1][stlpec];
                int j = this.system.getN() - 1;
                while (j > 0) {
                    this.system.data[k - 1][j] = this.system.data[k - 1][j].minus(alpha.times(this.system.data[i][j]));
                    --j;
                }
                --k;
            }
            --stlpec;
            if (this.verbose) {
                System.out.println(this.system.print(this.rankAb, this.system.getN()));
            }
            --i;
        }
    }

    private void solveSquare(int m) {
        this.x = new ArrayList(this.system.getN());
        this.toIdentity(m);
        int i = 0;
        while (i < m) {
            this.x.add(this.system.data[i][this.system.getN() - 1]);
            this.solution.solution.add(this.system.data[i][this.system.getN() - 1].toEntry());
            ++i;
        }
        if (this.gpu) {
            this.solution.textSolution.append("The GP/GPU solution with BigRational is: <br>y = " + this.x.toString());
        } else {
            this.solution.textSolution.append("The solution with BigRational is: y = " + this.x.toString());
        }
    }

    private void solveRectangular(int m) {
        int k;
        this.v = new ArrayList(this.system.getN());
        this.p = new ArrayList[this.parameters.size()];
        this.toIdentity(m);
        int i = 0;
        int k2 = 0;
        while (k2 < this.system.getN() - 1) {
            if (this.parameters.contains(k2)) {
                this.v.add(BigRational.ZERO);
            } else {
                this.v.add(this.system.data[i][this.system.getN() - 1]);
                this.solution.solution.add(this.system.data[i][this.system.getN() - 1].toEntry());
                ++i;
            }
            ++k2;
        }
        int y = 0;
        i = 0;
        while (i < this.parameters.size()) {
            this.p[i] = new ArrayList(this.system.getN());
            k = 0;
            while (k < this.system.getN() - 1) {
                if (this.parameters.contains(k)) {
                    if (k == this.parameters.get(i)) {
                        this.p[i].add(new BigRational(1));
                    } else {
                        this.p[i].add(BigRational.ZERO);
                    }
                } else {
                    this.p[i].add(this.system.data[y++][this.parameters.get(i)].times(new BigRational(-1)));
                }
                ++k;
            }
            y = 0;
            ++i;
        }
        if (this.gpu) {
            this.solution.textSolution.append("The GP/GPU solution with BigRational is: <br>y = ");
        } else {
            this.solution.textSolution.append("The solution with BigRational is: y = ");
        }
        this.solution.textSolution.append(this.v.toString());
        k = 0;
        while (k < this.parameters.size()) {
            this.solution.textSolution.append(" +\np");
            this.solution.textSolution.append(k);
            this.solution.textSolution.append("  ");
            this.solution.textSolution.append(this.p[k].toString());
            ++k;
        }
    }

    public StringBuilder printSystem() {
        StringBuilder matrix = new StringBuilder();
        Formatter formater = new Formatter(matrix);
        int i = 0;
        while (i < this.system.getM()) {
            int j = 0;
            while (j < this.system.getN()) {
                if (j == this.system.getN() - 1) {
                    matrix.append(" =");
                }
                formater.format("%5s", this.system.data[i][j]);
                ++j;
            }
            matrix.append("\n");
            ++i;
        }
        matrix.append("\n");
        return matrix;
    }

    private static int roundUp(int groupSize, int globalSize) {
        int r = globalSize % groupSize;
        if (r == 0) {
            return globalSize;
        }
        return globalSize + groupSize - r;
    }

    private static void fillBuffer(LongBuffer buffer) {
        while (buffer.remaining() != 0) {
            buffer.put(5L);
        }
        buffer.rewind();
    }
}

