/*
 * Decompiled with CFR 0.152.
 */
package LESSolver;

import LESSolver.FloatMatrix;
import LESSolver.ILESSolution;
import LESSolver.LESSolution;
import LESSolver.SystemOfEquations;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class SoEFloatGPU {
    private int rankA;
    private int rankAb;
    List<Integer> parameters;
    public boolean verbose = false;
    private ArrayList<Float> x;
    private ArrayList<Float> v;
    private ArrayList<Float>[] p;
    private LESSolution solution;
    private FloatMatrix system;
    private float[][] fData;
    private long memory = 0L;
    long nt;

    public SoEFloatGPU(FloatMatrix matrix) {
        this.system = matrix;
        this.fData = this.system.getfData();
        this.solution = new LESSolution();
    }

    public ILESSolution solve() {
        this.toStepForm();
        if (this.setRanks()) {
            if (this.findParameters(this.rankAb) == 0) {
                this.solveSquare(this.rankAb);
            } else {
                this.solveRectangular(this.rankAb);
            }
        } else {
            this.solution.textSolution.append("System nema riesenie.");
        }
        this.solution.textSolution.append("<br><br>The computation took: <b>" + this.nt / 1000L + " \u010f\u017c\u02dds</b><br><br>");
        return this.solution;
    }

    private void toStepForm() {
        StringBuilder log = new StringBuilder("Uprava systemu na stupnovity tvar:\n\n");
        CLProgram program = null;
        long gpu_time = 0L;
        long cpu_time = 0L;
        long conversion_time = 0L;
        CLContext context = CLContext.create();
        CLDevice[] devices = context.getDevices();
        if (this.verbose) {
            CLDevice[] cLDeviceArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                CLDevice d = cLDeviceArray[n2];
                System.out.println("\n" + d);
                System.out.println("Vendor: " + d.getVendor());
                System.out.println("Global Memory: " + d.getGlobalMemSize() / 1000000L + " MB");
                System.out.println("Max Memory Alloc: " + d.getMaxMemAllocSize() / 1000000L + " MB");
                System.out.println("Local Memory: " + d.getLocalMemSize() / 1000L + " KB");
                System.out.println("Driver: " + d.getDriverVersion());
                System.out.println("Frequency: " + d.getMaxClockFrequency());
                System.out.println("Max Unit Comupute: " + d.getMaxComputeUnits());
                System.out.println("Max Global Work Size: " + d.getMaxWorkGroupSize());
                ++n2;
            }
        }
        CLDevice device = context.getMaxFlopsDevice(CLDevice.Type.GPU) != null ? context.getMaxFlopsDevice(CLDevice.Type.GPU) : context.getMaxFlopsDevice();
        CLCommandQueue queue = device.createCommandQueue();
        try {
            program = context.createProgram(new InputStream[]{SystemOfEquations.class.getResourceAsStream("FSolve.cl")}).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int column = -1;
        boolean flag = false;
        int row = 0;
        while (row < this.system.getM()) {
            if (++column > this.system.getN() - 2) {
                return;
            }
            if (flag) {
                flag = false;
            }
            int max = --row;
            int i = row + 1;
            while (i < this.system.getM()) {
                float b;
                float a = this.fData[i][column] > 0.0f ? this.fData[i][column] : this.fData[i][column] * -1.0f;
                float f = b = this.fData[max][column] > 0.0f ? this.fData[max][column] : this.fData[max][column] * -1.0f;
                if (this.compare(a, b) > 0) {
                    max = i;
                }
                ++i;
            }
            float[] temp = this.fData[row];
            this.fData[row] = this.fData[max];
            this.fData[max] = temp;
            if (this.fData[row][column] == 0.0f) {
                flag = true;
            } else {
                float alpha = this.fData[row][column];
                int i2 = column;
                while (i2 < this.system.getN()) {
                    this.fData[row][i2] = this.fData[row][i2] / alpha;
                    ++i2;
                }
                int elementCount = (this.system.getM() - (row + 1)) * (this.system.getN() - column);
                if (elementCount != 0) {
                    int localWorkSize = 256;
                    int globalWorkSize = SoEFloatGPU.roundUp(localWorkSize, elementCount);
                    CLBuffer clBufferA = context.createFloatBuffer(elementCount, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                    CLBuffer clBufferB = context.createFloatBuffer(elementCount, new CLMemory.Mem[]{CLMemory.Mem.WRITE_ONLY});
                    CLBuffer actualRow = context.createFloatBuffer(this.system.getN() - column, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                    i2 = row + 1;
                    while (i2 < this.system.getM()) {
                        int j = column;
                        while (j < this.system.getN()) {
                            ((FloatBuffer)clBufferA.getBuffer()).put(this.fData[i2][j]);
                            ++j;
                        }
                        ++i2;
                    }
                    int j = column;
                    while (j < this.system.getN()) {
                        ((FloatBuffer)actualRow.getBuffer()).put(this.fData[row][j]);
                        ++j;
                    }
                    ((FloatBuffer)clBufferA.getBuffer()).rewind();
                    ((FloatBuffer)clBufferB.getBuffer()).rewind();
                    ((FloatBuffer)actualRow.getBuffer()).rewind();
                    CLKernel kernel = program.createCLKernel("MatrixStepForm");
                    kernel.putArgs(new CLMemory[]{clBufferA, clBufferB, actualRow}).putArg(this.system.getM() - (row + 1)).putArg(this.system.getN() - column);
                    long nt = System.nanoTime();
                    this.memory += clBufferA.getCLSize() + clBufferB.getCLSize() + actualRow.getCLSize();
                    queue.putWriteBuffer(clBufferA, true);
                    queue.putWriteBuffer(actualRow, true);
                    queue.put1DRangeKernel(kernel, 0L, (long)globalWorkSize, (long)localWorkSize);
                    queue.putReadBuffer(clBufferB, false);
                    gpu_time += System.nanoTime() - nt;
                    int i3 = 0;
                    while (i3 < this.system.getM() - (row + 1)) {
                        int j2 = 0;
                        while (j2 < this.system.getN() - column) {
                            this.fData[i3 + row + 1][j2 + column] = ((FloatBuffer)clBufferB.getBuffer()).get(i3 * (this.system.getN() - column) + j2);
                            ++j2;
                        }
                        ++i3;
                    }
                    clBufferA.release();
                    clBufferB.release();
                    actualRow.release();
                }
            }
            ++row;
        }
        context.release();
        this.nt = gpu_time;
        float time = gpu_time;
        float cTime = conversion_time;
        if (this.verbose) {
            if (time / 1.0E9f > 1.0f) {
                System.out.println("GPU computation took: " + time / 1.0E9f + " s");
                System.out.println("Buffer conversion took: " + cTime / 1.0E9f + " s");
            } else if (time / 1.0E7f > 1.0f) {
                System.out.println("GPU computation took: " + time / 1000000.0f + " ms");
                System.out.println("Buffer conversion took: " + cTime / 1000000.0f + " ms");
            } else if (time / 10000.0f > 1.0f) {
                System.out.println("GPU computation took: " + time / 1000.0f + " \u010f\u017c\u02dds");
                System.out.println("Buffer conversion took: " + cTime / 1000.0f + " \u010f\u017c\u02dds");
            }
            System.out.format("used total device memory: %,d MB", this.memory / 1000000L);
            System.out.println(log.toString());
        }
    }

    private boolean setRanks() {
        int zeroRowsA = 0;
        int zeroRowsAb = 0;
        int m = this.system.getM() - 1;
        while (m >= 0) {
            int n = 0;
            while (n < this.system.getN()) {
                if (this.fData[m][n] != 0.0f) break;
                if (n == this.system.getN() - 2) {
                    ++zeroRowsA;
                }
                if (n == this.system.getN() - 1) {
                    ++zeroRowsAb;
                }
                ++n;
            }
            if (this.fData[m][this.system.getN() - 2] != 0.0f) break;
            --m;
        }
        this.rankA = this.system.getM() - zeroRowsA;
        this.rankAb = this.system.getM() - zeroRowsAb;
        return this.rankAb == this.rankA;
    }

    private int findParameters(int m) {
        this.parameters = new ArrayList<Integer>();
        int j = 0;
        int i = 0;
        while (i < m) {
            if (this.fData[i][j] == 0.0f) {
                this.parameters.add(j);
                --i;
            }
            ++j;
            ++i;
        }
        while (j < this.system.getN() - 1) {
            this.parameters.add(j);
            ++j;
        }
        return this.parameters.size();
    }

    private void toIdentity(int m) {
        int stlpec = this.system.getN() - 2;
        int i = m - 1;
        while (i > 0) {
            int k = i;
            while (k > 0) {
                while (this.parameters.contains(stlpec)) {
                    --stlpec;
                }
                float alpha = this.fData[k - 1][stlpec];
                int j = this.system.getN() - 1;
                while (j > 0) {
                    this.fData[k - 1][j] = this.fData[k - 1][j] - alpha * this.fData[i][j];
                    --j;
                }
                --k;
            }
            --stlpec;
            if (this.verbose) {
                this.system.print(this.rankAb, this.system.getN());
            }
            --i;
        }
    }

    private void solveSquare(int m) {
        this.x = new ArrayList(this.system.getN());
        this.toIdentity(m);
        int i = 0;
        while (i < m) {
            this.x.add(Float.valueOf(this.fData[i][this.system.getN() - 1]));
            ++i;
        }
        this.solution.textSolution.append("The GP/GPU solution with Real is: <br>y = " + this.x.toString());
    }

    private void solveRectangular(int m) {
        int k;
        this.v = new ArrayList(this.system.getN());
        this.p = new ArrayList[this.parameters.size()];
        this.toIdentity(m);
        int i = 0;
        int k2 = 0;
        while (k2 < this.system.getN() - 1) {
            if (this.parameters.contains(k2)) {
                this.v.add(Float.valueOf(0.0f));
            } else {
                this.v.add(Float.valueOf(this.fData[i++][this.system.getN() - 1]));
            }
            ++k2;
        }
        int y = 0;
        i = 0;
        while (i < this.parameters.size()) {
            this.p[i] = new ArrayList(this.system.getN());
            k = 0;
            while (k < this.system.getN() - 1) {
                if (this.parameters.contains(k)) {
                    if (k == this.parameters.get(i)) {
                        this.p[i].add(Float.valueOf(1.0f));
                    } else {
                        this.p[i].add(Float.valueOf(0.0f));
                    }
                } else {
                    this.p[i].add(Float.valueOf(this.fData[y++][this.parameters.get(i)] * -1.0f));
                }
                ++k;
            }
            y = 0;
            ++i;
        }
        this.solution.textSolution.append("The GP/GPU solution with Real is: \n\ny = ");
        this.solution.textSolution.append(this.v.toString());
        k = 0;
        while (k < this.parameters.size()) {
            this.solution.textSolution.append(" +\np");
            this.solution.textSolution.append(k);
            this.solution.textSolution.append("  ");
            this.solution.textSolution.append(this.p[k].toString());
            ++k;
        }
    }

    private int compare(float a, float b) {
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    private static int roundUp(int groupSize, int globalSize) {
        int r = globalSize % groupSize;
        if (r == 0) {
            return globalSize;
        }
        return globalSize + groupSize - r;
    }
}

