/*
 * Decompiled with CFR 0.152.
 */
package pnexport;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;

public class PNMLSaver {
    private String fileName;
    private boolean extension;
    private boolean successful;

    public PNMLSaver(String fileName, boolean extension) {
        this.fileName = fileName;
        this.extension = extension;
    }

    public boolean save(IPetriNet net) {
        try {
            this.successful = false;
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.fileName));
            String s = this.generateHeader();
            s = String.valueOf(s) + this.generateNet(net, this.extension);
            s = String.valueOf(s) + this.generateFooter();
            dos.writeBytes(s);
            dos.close();
        }
        catch (Exception e) {
            System.out.println("error onOpenFile: " + e.toString());
        }
        return this.successful;
    }

    private String generateHeader() {
        String ret = "";
        ret = this.extension ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<pnml>\n" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<pnml xmlns=\"http://www.pnml.org/version-2009/grammar/pnml\">\n";
        return ret;
    }

    private String generateNet(IPetriNet net, boolean extension) {
        String s = "";
        if (extension) {
            s = String.valueOf(s) + "  <net id=\"" + net.getId() + "\" type=\"" + net.getType() + "\">\n";
            s = String.valueOf(s) + "    <name>\n";
            s = String.valueOf(s) + "      <text>" + net.getName() + "</text>\n";
            s = String.valueOf(s) + "    </name>\n";
            s = String.valueOf(s) + "    <page id=\"page0\">\n";
        } else {
            s = String.valueOf(s) + "  <net id=\"" + net.getId() + "\" type=\"http://www.pnml.org/version-2009/grammar/pnmlcoremodel\">\n";
            s = String.valueOf(s) + "    <name>\n";
            s = String.valueOf(s) + "      <text>" + net.getName() + "</text>\n";
            s = String.valueOf(s) + "    </name>\n";
            s = String.valueOf(s) + "    <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            s = String.valueOf(s) + "      <type>" + net.getType() + "</type>\n";
            s = String.valueOf(s) + "    </toolspecific>\n";
            s = String.valueOf(s) + "    <page id=\"page0\">\n";
        }
        int i = 0;
        while (i < net.getPlaces().size()) {
            s = String.valueOf(s) + this.generatePlace(net.getPlaces().get(i), net);
            ++i;
        }
        i = 0;
        while (i < net.getTransitions().size()) {
            s = String.valueOf(s) + this.generateTransition(net.getTransitions().get(i), net);
            ++i;
        }
        i = 0;
        while (i < net.getArcs().size()) {
            s = String.valueOf(s) + this.generateArcs(net.getArcs().get(i));
            ++i;
        }
        String mw = null;
        if (net.getAdditionalData() instanceof Properties) {
            if (((Properties)net.getAdditionalData()).get("mwAutomaton") instanceof String) {
                mw = (String)((Properties)net.getAdditionalData()).get("mwAutomaton");
            } else if (((Properties)net.getAdditionalData()).get("mwAutomaton") instanceof Node) {
                mw = this.elementToString((Node)((Properties)net.getAdditionalData()).get("mwAutomaton"));
            }
        }
        if (mw != null) {
            s = String.valueOf(s) + "  <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            s = String.valueOf(s) + mw;
            s = String.valueOf(s) + "  </toolspecific>\n";
        }
        s = String.valueOf(s) + "    </page>\n";
        s = String.valueOf(s) + "  </net>\n";
        this.successful = true;
        return s;
    }

    private String generatePlace(IPlace p, IPetriNet pn) {
        ArrayList a;
        String s = "    <place id=\"" + p.getId() + "\">\n";
        s = String.valueOf(s) + "      <name>\n";
        s = String.valueOf(s) + "        <graphics>\n";
        s = String.valueOf(s) + "          <offset x=\"" + (int)(p.getNameX() - p.getX()) + "\" y=\"" + (int)(p.getNameY() - p.getY()) + "\" />\n";
        s = String.valueOf(s) + "        </graphics>\n";
        s = String.valueOf(s) + "        <text>" + p.getName() + "</text>\n";
        s = String.valueOf(s) + "      </name>\n";
        if (this.extension) {
            s = String.valueOf(s) + "      <initialMarking>\n";
            s = String.valueOf(s) + "        <graphics>\n";
            s = String.valueOf(s) + "          <offset x=\"0\" y=\"0\" />\n";
            s = String.valueOf(s) + "        </graphics>\n";
            s = String.valueOf(s) + "        <text>" + p.getTokens() + "</text>\n";
            s = String.valueOf(s) + "      </initialMarking>\n";
        }
        s = String.valueOf(s) + "      <graphics>\n";
        s = String.valueOf(s) + "        <position x=\"" + (int)p.getX() + "\" y=\"" + (int)p.getY() + "\" />\n";
        int red = ((Color)((Properties)p.getAdditionalData()).get("Color")).getRed();
        int green = ((Color)((Properties)p.getAdditionalData()).get("Color")).getGreen();
        int blue = ((Color)((Properties)p.getAdditionalData()).get("Color")).getBlue();
        s = String.valueOf(s) + "        <fill color=\"rgb(" + red + "," + green + "," + blue + ")\" />\n";
        s = String.valueOf(s) + "      </graphics>\n";
        if (!this.extension) {
            s = String.valueOf(s) + "      <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            s = String.valueOf(s) + "        <initialMarking>\n";
            s = String.valueOf(s) + "          <graphics>\n";
            s = String.valueOf(s) + "            <offset x=\"0\" y=\"0\" />\n";
            s = String.valueOf(s) + "          </graphics>\n";
            s = String.valueOf(s) + "          <text>" + p.getTokens() + "</text>\n";
            s = String.valueOf(s) + "        </initialMarking>\n";
        }
        if (pn.getType().equals("EvPN") && p.getType() != null) {
            if (p.getType().equals("p")) {
                s = String.valueOf(s) + "        <evpnPlace type=\"p\" />\n";
            }
            if (p.getType().equals("pf")) {
                s = String.valueOf(s) + "        <evpnPlace type=\"pf\" >\n";
                s = String.valueOf(s) + "          <exp>" + ((Properties)p.getAdditionalData()).getProperty("EvPN Pf") + "</exp>\n";
                s = String.valueOf(s) + "        </evpnPlace>\n";
            }
            if (p.getType().equals("pe")) {
                s = String.valueOf(s) + "        <evpnPlace type=\"pe\" >\n";
                s = String.valueOf(s) + "          <exp>" + ((Properties)p.getAdditionalData()).getProperty("EvPN Pe") + "</exp>\n";
                s = String.valueOf(s) + "        </evpnPlace>\n";
            }
        }
        if (pn.getType().equals("TB") && p.getAdditionalData() instanceof Properties && ((Properties)p.getAdditionalData()).containsKey("TB Tokens") && ((Properties)p.getAdditionalData()).get("TB Tokens") instanceof ArrayList && (a = (ArrayList)((Properties)p.getAdditionalData()).get("TB Tokens")).size() > 0) {
            s = String.valueOf(s) + "        <tbPlace>\n";
            int i = 0;
            while (i < a.size()) {
                s = String.valueOf(s) + "          <token minValue=\"" + Math.round(((double[])a.get(i))[0]) + "\" maxValue=\"" + Math.round(((double[])a.get(i))[1]) + "\" />\n";
                ++i;
            }
            s = String.valueOf(s) + "        </tbPlace>\n";
        }
        if (!this.extension) {
            s = String.valueOf(s) + "      </toolspecific>\n";
        }
        s = String.valueOf(s) + "    </place>\n";
        return s;
    }

    private String generateTransition(ITransition t, IPetriNet pn) {
        String s = "    <transition id=\"" + t.getId() + "\">\n";
        s = String.valueOf(s) + "      <name>\n";
        s = String.valueOf(s) + "        <graphics>\n";
        s = String.valueOf(s) + "          <offset x=\"" + (int)(t.getNameX() - t.getX()) + "\" y=\"" + (int)(t.getNameY() - t.getY()) + "\" />\n";
        s = String.valueOf(s) + "        </graphics>\n";
        s = String.valueOf(s) + "        <text>" + t.getName() + "</text>\n";
        s = String.valueOf(s) + "      </name>\n";
        s = String.valueOf(s) + "      <graphics>\n";
        s = String.valueOf(s) + "        <position x=\"" + (int)t.getX() + "\" y=\"" + (int)t.getY() + "\" />\n";
        int red = ((Color)((Properties)t.getAdditionalData()).get("Color")).getRed();
        int green = ((Color)((Properties)t.getAdditionalData()).get("Color")).getGreen();
        int blue = ((Color)((Properties)t.getAdditionalData()).get("Color")).getBlue();
        s = String.valueOf(s) + "        <fill color=\"rgb(" + red + "," + green + "," + blue + ")\" />\n";
        s = String.valueOf(s) + "      </graphics>\n";
        if (pn.getType().equals("TB") && t.getAdditionalData() instanceof Properties && ((Properties)t.getAdditionalData()).containsKey("TB Function") && ((Properties)t.getAdditionalData()).get("TB Function") != null) {
            if (!this.extension) {
                s = String.valueOf(s) + "      <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            }
            s = String.valueOf(s) + "        <tbTransition>\n";
            s = String.valueOf(s) + "          <tbFunction>" + (String)((Properties)t.getAdditionalData()).get("TB Function") + "</tbFunction>\n";
            s = String.valueOf(s) + "        </tbTransition>\n";
            if (!this.extension) {
                s = String.valueOf(s) + "      </toolspecific>\n";
            }
        }
        s = String.valueOf(s) + "    </transition>\n";
        return s;
    }

    private String generateArcs(IArc a) {
        String s = "    <arc id=\"" + a.getId() + "\" source=\"" + a.getStartingVertex().getId() + "\" target=\"" + a.getEndingVertex().getId() + "\">\n";
        if (this.extension) {
            s = String.valueOf(s) + "      <inscription>\n";
            s = String.valueOf(s) + "        <graphics>\n";
            s = String.valueOf(s) + "          <offset x=\"" + (int)a.getCountX() + "\" y=\"" + (int)a.getCountY() + "\" />\n";
            s = String.valueOf(s) + "        </graphics>\n";
            s = String.valueOf(s) + "        <text>" + a.getCount() + "</text>\n";
            s = String.valueOf(s) + "      </inscription>\n";
        }
        if (a.getKnots().size() > 0) {
            s = String.valueOf(s) + "      <graphics>\n";
            int i = 0;
            while (i < a.getKnots().size()) {
                s = String.valueOf(s) + "        <position x=\"" + (int)a.getKnots().get(i)[0] + "\" y=\"" + (int)a.getKnots().get(i)[1] + "\" />\n";
                ++i;
            }
            s = String.valueOf(s) + "      </graphics>\n";
        }
        if (!this.extension) {
            s = String.valueOf(s) + "      <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            s = String.valueOf(s) + "        <inscription>\n";
            s = String.valueOf(s) + "          <graphics>\n";
            s = String.valueOf(s) + "            <offset x=\"" + (int)a.getCountX() + "\" y=\"" + (int)a.getCountY() + "\" />\n";
            s = String.valueOf(s) + "          </graphics>\n";
            s = String.valueOf(s) + "          <text>" + a.getCount() + "</text>\n";
            s = String.valueOf(s) + "        </inscription>\n";
        }
        if (a.getAdditionalData() instanceof Properties) {
            if (((Properties)a.getAdditionalData()).get("EvPN d") instanceof Boolean && ((Boolean)((Properties)a.getAdditionalData()).get("EvPN d")).booleanValue()) {
                s = String.valueOf(s) + "        <evpnArc type=\"d\" />\n";
            }
            if (((Properties)a.getAdditionalData()).get("EvPN w") instanceof Integer) {
                if ((Integer)((Properties)a.getAdditionalData()).get("EvPN w") == -1) {
                    s = String.valueOf(s) + "        <evpnArc type=\"omega\">\n";
                } else {
                    s = String.valueOf(s) + "        <evpnArc type=\"c\">\n";
                    s = String.valueOf(s) + "          <capacity>" + (Integer)((Properties)a.getAdditionalData()).get("EvPN w") + "</capacity>\n";
                }
                if (((Properties)a.getAdditionalData()).get("EvPN Function") instanceof String) {
                    s = String.valueOf(s) + "          <relPlace>" + (String)((Properties)a.getAdditionalData()).get("EvPN Function") + "</relPlace>\n";
                }
                s = String.valueOf(s) + "        </evpnArc>\n";
            }
        }
        if (!this.extension) {
            s = String.valueOf(s) + "      </toolspecific>\n";
        }
        s = String.valueOf(s) + "    </arc>\n";
        return s;
    }

    private String generateFooter() {
        return "</pnml>\n";
    }

    private String elementToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

