/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pnexport.PNMLFilter;
import pnexport.PNMLSaver;

public class ModuleImpl
extends JPanel
implements IModule {
    private IPetriNet petriNet;
    private ArrayList<IResponseListener> responseListeners;
    private PNMLSaver saver;
    private PNMLFilter tina;
    private PNMLFilter standard;
    private JButton jButton1;

    public ModuleImpl() {
        this.initComponents();
        this.responseListeners = new ArrayList();
        this.tina = new PNMLFilter("Tina PNML");
        this.standard = new PNMLFilter("Standard PNML");
    }

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PNML Export module</h1>Authors: Peter Antal, Stefan Korecko</html>";
    }

    @Override
    public String getHTMLHelpSK() {
        return "modules/modulesHelp/pnexport_sk.html";
    }

    @Override
    public String getHTMLHelpENG() {
        return "modules/modulesHelp/pnexport_eng.html";
    }

    @Override
    public String getTarget() {
        return "pnexport";
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        this.petriNet = pn;
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
    }

    @Override
    public void open() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(this.tina);
        fc.addChoosableFileFilter(this.standard);
        fc.setFileFilter(this.tina);
        fc.setCurrentDirectory(new File("./"));
        int a = fc.showSaveDialog(null);
        if (a == 0) {
            String filePath = fc.getSelectedFile().getAbsolutePath();
            int i = filePath.lastIndexOf(46);
            if (i > -1 && i < filePath.length()) {
                if (!filePath.substring(i + 1).equals("pnml")) {
                    filePath = String.valueOf(filePath) + ".pnml";
                }
            } else {
                filePath = String.valueOf(filePath) + ".pnml";
            }
            boolean successful = true;
            if (fc.getFileFilter().equals(this.tina)) {
                this.saver = new PNMLSaver(filePath, true);
                this.saver.save(this.petriNet);
            }
            if (fc.getFileFilter().equals(this.standard)) {
                this.saver = new PNMLSaver(filePath, false);
                successful = this.saver.save(this.petriNet);
            }
            if (successful) {
                JOptionPane.showMessageDialog(null, "Petri nets have been exported successfully.", this.getName(), 1);
            }
        }
    }

    @Override
    public void close() {
        this.petriNet = null;
    }

    @Override
    public String getName() {
        return "PNML Export";
    }

    @Override
    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Export do PNML";
        }
        if (prefix.equals("_eng")) {
            languageName = "Export to PNML";
        }
        return languageName;
    }

    @Override
    public JComponent getControlPanel() {
        return this;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pnexport/icon.png")));
        this.jButton1.setToolTipText("Export to PNML");
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 59, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 37, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.petriNet = null;
        int i = 0;
        while (i < this.responseListeners.size()) {
            ArrayList<IPetriNet> a = this.responseListeners.get(i).requestPetriNets();
            if (a != null) {
                this.addPetriNet(a.get(0));
            }
            ++i;
        }
        if (this.petriNet != null) {
            this.open();
        }
    }
}

