/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.util.concurrent.CLExecutorService;
import com.jogamp.opencl.util.concurrent.CLPoolable;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLTaskCompletionService<R> {
    private final ExecutorCompletionService<R> service;
    private final CLExecutorService executor;

    public CLTaskCompletionService(CLExecutorService executor) {
        this.service = new ExecutorCompletionService(executor.getExcecutor());
        this.executor = executor;
    }

    public CLTaskCompletionService(CLExecutorService pool, BlockingQueue<Future<R>> queue) {
        this.service = new ExecutorCompletionService(pool.getExcecutor(), queue);
        this.executor = pool;
    }

    public Future<R> submit(CLPoolable<? extends CLQueueContext, R> task) {
        return this.service.submit(this.executor.wrapTask(task));
    }

    public Future<R> take() throws InterruptedException {
        return this.service.take();
    }

    public Future<R> poll() {
        return this.service.poll();
    }

    public Future<R> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.poll(timeout, unit);
    }
}

