/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLResource;
import java.util.Map;

public abstract class CLQueueContext
implements CLResource {
    public final CLCommandQueue queue;

    public CLQueueContext(CLCommandQueue queue) {
        this.queue = queue;
    }

    public CLCommandQueue getQueue() {
        return this.queue;
    }

    public CLContext getCLContext() {
        return this.queue.getContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CLSingleProgramQueueContext
    extends CLQueueContext {
        public final CLProgram program;
        public final Map<String, CLKernel> kernels;

        public CLSingleProgramQueueContext(CLCommandQueue queue, CLProgram program) {
            super(queue);
            this.program = program;
            this.kernels = program.createCLKernels();
        }

        public CLSingleProgramQueueContext(CLCommandQueue queue, String ... source) {
            this(queue, queue.getContext().createProgram(source).build());
        }

        public Map<String, CLKernel> getKernels() {
            return this.kernels;
        }

        public CLKernel getKernel(String name) {
            return this.kernels.get(name);
        }

        public CLProgram getProgram() {
            return this.program;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            CLProgram cLProgram = this.program;
            synchronized (cLProgram) {
                if (!this.program.isReleased()) {
                    this.program.release();
                }
            }
        }

        @Override
        public boolean isReleased() {
            return this.program.isReleased();
        }
    }
}

