/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.util.CLMultiContext;
import com.jogamp.opencl.util.concurrent.CLExecutorService;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import com.jogamp.opencl.util.concurrent.CLRecursiveTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLForkJoinPool
extends CLExecutorService {
    private CLForkJoinPool(ExecutorService executor, List<CLCommandQueue> queues) {
        super(executor, queues);
    }

    public static CLForkJoinPool create(CLMultiContext mc, CLCommandQueue.Mode ... modes) {
        return CLForkJoinPool.create(mc.getDevices(), modes);
    }

    public static CLForkJoinPool create(Collection<? extends CLDevice> devices, CLCommandQueue.Mode ... modes) {
        ArrayList<CLCommandQueue> queues = new ArrayList<CLCommandQueue>(devices.size());
        for (CLDevice cLDevice : devices) {
            queues.add(cLDevice.createCommandQueue(modes));
        }
        return CLForkJoinPool.create(queues);
    }

    public static CLForkJoinPool create(Collection<CLCommandQueue> queues) {
        ArrayList<CLCommandQueue> list = new ArrayList<CLCommandQueue>(queues);
        CLThreadFactory factory = new CLThreadFactory(list);
        int size = list.size();
        ForkJoinPool service = new ForkJoinPool(size, factory, null, false);
        return new CLForkJoinPool(service, list);
    }

    public <R> R invoke(CLRecursiveTask<? extends CLQueueContext, R> task) {
        return (R)this.getExcecutor().invoke(task);
    }

    public <R> Future<R> submit(CLRecursiveTask<? extends CLQueueContext, R> task) {
        return this.getExcecutor().submit(task);
    }

    @Override
    ForkJoinPool getExcecutor() {
        return (ForkJoinPool)super.getExcecutor();
    }

    public long getStealCount() {
        return this.getExcecutor().getStealCount();
    }

    public int getQueuedSubmissionCount() {
        return this.getExcecutor().getQueuedSubmissionCount();
    }

    public long getQueuedTaskCount() {
        return this.getExcecutor().getQueuedTaskCount();
    }

    public boolean hasQueuedSubmissions() {
        return this.getExcecutor().hasQueuedSubmissions();
    }

    public boolean isQuiescent() {
        return this.getExcecutor().isQuiescent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ForkJoinQueueWorkerThread
    extends ForkJoinWorkerThread
    implements CLExecutorService.CommandQueueThread {
        private final CLCommandQueue queue;
        private final Map<Object, CLQueueContext> contextMap;

        public ForkJoinQueueWorkerThread(ForkJoinPool pool, CLCommandQueue queue) {
            super(pool);
            this.queue = queue;
            this.contextMap = new HashMap<Object, CLQueueContext>();
        }

        @Override
        public void run() {
            super.run();
            this.queue.finish();
            for (CLQueueContext context : this.contextMap.values()) {
                context.release();
            }
        }

        @Override
        public Map<Object, CLQueueContext> getContextMap() {
            return this.contextMap;
        }

        @Override
        public CLCommandQueue getQueue() {
            return this.queue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CLThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private int index = 0;
        private final List<CLCommandQueue> queues;

        private CLThreadFactory(List<CLCommandQueue> queues) {
            this.queues = queues;
        }

        @Override
        public synchronized ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinQueueWorkerThread(pool, this.queues.get(this.index++));
        }
    }
}

