/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class CLTLInfoAccessor
implements CLInfoAccessor {
    private static final int BB_SIZE = 512;
    protected static final ThreadLocal<ByteBuffer> localBB = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return Buffers.newDirectByteBuffer(512);
        }
    };
    protected static final ThreadLocal<NativeSizeBuffer> localNSB = new ThreadLocal<NativeSizeBuffer>(){

        @Override
        protected NativeSizeBuffer initialValue() {
            return NativeSizeBuffer.allocateDirect(1);
        }
    };

    public final long getLong(int key) {
        ByteBuffer buffer = this.getBB(8).putLong(0, 0L);
        int ret = this.getInfo(key, 8L, buffer, null);
        CLException.checkForError(ret, "error while asking for info value");
        return buffer.getLong(0);
    }

    public final String getString(int key) {
        NativeSizeBuffer sizeBuffer = this.getNSB();
        int ret = this.getInfo(key, 0L, null, sizeBuffer);
        CLException.checkForError(ret, "error while asking for info string");
        int clSize = (int)sizeBuffer.get(0);
        ByteBuffer buffer = this.getBB(clSize);
        ret = this.getInfo(key, buffer.capacity(), buffer, null);
        CLException.checkForError(ret, "error while asking for info string");
        byte[] array = new byte[clSize];
        buffer.get(array).rewind();
        return CLUtil.clString2JavaString(array, clSize);
    }

    public final int[] getInts(int key, int n) {
        ByteBuffer buffer = this.getBB(n * (Platform.is32Bit() ? 4 : 8));
        int ret = this.getInfo(key, buffer.capacity(), buffer, null);
        CLException.checkForError(ret, "error while asking for info value");
        int[] array = new int[n];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Platform.is32Bit() ? buffer.getInt() : (int)buffer.getLong();
        }
        buffer.rewind();
        return array;
    }

    protected ByteBuffer getBB(int minCapacity) {
        if (minCapacity > 512) {
            return Buffers.newDirectByteBuffer(minCapacity);
        }
        return localBB.get();
    }

    protected NativeSizeBuffer getNSB() {
        return localNSB.get();
    }

    protected abstract int getInfo(int var1, long var2, Buffer var4, NativeSizeBuffer var5);
}

