/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;

public class CLWork {
    public final int dimension;
    public final CLKernel kernel;
    protected final NativeSizeBuffer groupSize;
    protected final NativeSizeBuffer workSize;
    protected final NativeSizeBuffer workOffset;

    protected CLWork(CLKernel kernel, int dimension) {
        int size = dimension * NativeSizeBuffer.elementSize();
        CachedBufferFactory factory = CachedBufferFactory.create(3 * size, true);
        this.workOffset = NativeSizeBuffer.wrap(factory.newDirectByteBuffer(size));
        this.workSize = NativeSizeBuffer.wrap(factory.newDirectByteBuffer(size));
        this.groupSize = NativeSizeBuffer.wrap(factory.newDirectByteBuffer(size));
        this.dimension = dimension;
        this.kernel = kernel;
    }

    public static CLWork1D create1D(CLKernel kernel) {
        return new CLWork1D(kernel);
    }

    public static CLWork2D create2D(CLKernel kernel) {
        return new CLWork2D(kernel);
    }

    public static CLWork3D create3D(CLKernel kernel) {
        return new CLWork3D(kernel);
    }

    public static long roundUp(long value, long multiple) {
        long remaining = value % multiple;
        if (remaining == 0L) {
            return value;
        }
        return value + multiple - remaining;
    }

    protected void checkSize(long worksize, long groupsize) {
        if (groupsize != 0L && worksize % groupsize != 0L) {
            throw new IllegalArgumentException("worksize must be a multiple of groupsize");
        }
    }

    public CLWork optimizeFor(CLDevice device) {
        long multiple = this.kernel.getPreferredWorkGroupSizeMultiple(device);
        int[] maxWorkItemSizes = device.getMaxWorkItemSizes();
        for (int i = 0; i < this.dimension; ++i) {
            long group = this.groupSize.get(i);
            if (group <= 0L || (group = CLWork.roundUp(group, multiple)) > (long)maxWorkItemSizes[i]) continue;
            this.groupSize.put(i, group);
            long work = this.workSize.get(i);
            this.workSize.put(i, CLWork.roundUp(work, group));
        }
        return this;
    }

    public CLKernel getKernel() {
        return this.kernel;
    }

    public int getDimension() {
        return this.dimension;
    }

    public NativeSizeBuffer getGroupSize() {
        return this.groupSize;
    }

    public NativeSizeBuffer getWorkOffset() {
        return this.workOffset;
    }

    public NativeSizeBuffer getWorkSize() {
        return this.workSize;
    }

    public static class CLWork3D
    extends CLWork {
        private CLWork3D(CLKernel kernel) {
            super(kernel, 3);
        }

        public CLWork3D setWorkOffset(long offsetX, long offsetY, long offsetZ) {
            this.workOffset.put(0, offsetX).put(1, offsetY).put(2, offsetZ);
            return this;
        }

        public CLWork3D setWorkSize(long worksizeX, long worksizeY, long worksizeZ) {
            this.setWorkSize(worksizeX, worksizeY, worksizeZ, 0L, 0L, 0L);
            return this;
        }

        public CLWork3D setWorkSize(long worksizeX, long worksizeY, long worksizeZ, long groupsizeX, long groupsizeY, long groupsizeZ) {
            this.checkSize(worksizeX, groupsizeX);
            this.checkSize(worksizeY, groupsizeY);
            this.checkSize(worksizeZ, groupsizeZ);
            this.workSize.put(0, worksizeX).put(1, worksizeY).put(2, worksizeZ);
            this.groupSize.put(0, groupsizeX).put(1, groupsizeY).put(2, groupsizeZ);
            return this;
        }

        public CLWork3D optimizeFor(CLDevice device) {
            super.optimizeFor(device);
            return this;
        }
    }

    public static class CLWork2D
    extends CLWork {
        private CLWork2D(CLKernel kernel) {
            super(kernel, 2);
        }

        public CLWork2D setWorkOffset(long offsetX, long offsetY) {
            this.workOffset.put(0, offsetX).put(1, offsetY);
            return this;
        }

        public CLWork2D setWorkSize(long worksizeX, long worksizeY) {
            this.setWorkSize(worksizeX, worksizeY, 0L, 0L);
            return this;
        }

        public CLWork2D setWorkSize(long worksizeX, long worksizeY, long groupsizeX, long groupsizeY) {
            this.checkSize(worksizeX, groupsizeX);
            this.checkSize(worksizeY, groupsizeY);
            this.workSize.put(0, worksizeX).put(1, worksizeY);
            this.groupSize.put(0, groupsizeX).put(1, groupsizeY);
            return this;
        }

        public CLWork2D optimizeFor(CLDevice device) {
            super.optimizeFor(device);
            return this;
        }
    }

    public static class CLWork1D
    extends CLWork {
        private CLWork1D(CLKernel kernel) {
            super(kernel, 1);
        }

        public CLWork1D setWorkOffset(long offset) {
            this.workOffset.put(0, offset);
            return this;
        }

        public CLWork1D setWorkSize(long worksize) {
            this.setWorkSize(worksize, 0L);
            return this;
        }

        public CLWork1D setWorkSize(long worksize, long groupsize) {
            this.checkSize(worksize, groupsize);
            this.workSize.put(0, worksize);
            this.groupSize.put(0, groupsize);
            return this;
        }

        public CLWork1D optimizeFor(CLDevice device) {
            super.optimizeFor(device);
            return this;
        }
    }
}

