/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.llb.CLKernelBinding;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLKernel
extends CLObjectResource
implements Cloneable {
    public final String name;
    public final int numArgs;
    private final CLProgram program;
    private final CLKernelBinding binding;
    private final ByteBuffer buffer;
    private int argIndex;
    private boolean force32BitArgs;

    CLKernel(CLProgram program, long id) {
        this(program, null, id);
    }

    CLKernel(CLProgram program, String name, long id) {
        super(program.getContext(), id);
        this.program = program;
        this.buffer = Buffers.newDirectByteBuffer(32);
        this.binding = program.getPlatform().getKernelBinding();
        if (name == null) {
            NativeSizeBuffer size = NativeSizeBuffer.wrap(this.buffer);
            int ret = this.binding.clGetKernelInfo(this.ID, 4496, 0L, null, size);
            CLException.checkForError(ret, "error while asking for kernel function name");
            ByteBuffer bb = Buffers.newDirectByteBuffer((int)size.get(0));
            ret = this.binding.clGetKernelInfo(this.ID, 4496, bb.capacity(), bb, null);
            CLException.checkForError(ret, "error while asking for kernel function name");
            this.name = CLUtil.clString2JavaString(bb, bb.capacity());
        } else {
            this.name = name;
        }
        int ret = this.binding.clGetKernelInfo(this.ID, 4497, this.buffer.capacity(), this.buffer, null);
        CLException.checkForError(ret, "error while asking for number of function arguments.");
        this.numArgs = this.buffer.getInt(0);
    }

    public CLKernel putArg(Buffer value) {
        this.setArg(this.argIndex++, value);
        return this;
    }

    public CLKernel putArg(CLMemory<?> value) {
        this.setArg(this.argIndex, value);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(short value) {
        this.setArg(this.argIndex, value);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(short x, short y) {
        this.setArg(this.argIndex, x, y);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(short x, short y, short z) {
        this.setArg(this.argIndex, x, y, z);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(short x, short y, short z, short w) {
        this.setArg(this.argIndex, x, y, z, w);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(int value) {
        this.setArg(this.argIndex, value);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(int x, int y) {
        this.setArg(this.argIndex, x, y);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(int x, int y, int z) {
        this.setArg(this.argIndex, x, y, z);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(int x, int y, int z, int w) {
        this.setArg(this.argIndex, x, y, z, w);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(long value) {
        this.setArg(this.argIndex, value);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(long x, long y) {
        this.setArg(this.argIndex, x, y);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(long x, long y, long z) {
        this.setArg(this.argIndex, x, y, z);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(long x, long y, long z, long w) {
        this.setArg(this.argIndex, x, y, z, w);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(float value) {
        this.setArg(this.argIndex, value);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(float x, float y) {
        this.setArg(this.argIndex, x, y);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(float x, float y, float z) {
        this.setArg(this.argIndex, x, y, z);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(float x, float y, float z, float w) {
        this.setArg(this.argIndex, x, y, z, w);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(double value) {
        this.setArg(this.argIndex, value);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(double x, double y) {
        this.setArg(this.argIndex, x, y);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(double x, double y, double z) {
        this.setArg(this.argIndex, x, y, z);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArg(double x, double y, double z, double w) {
        this.setArg(this.argIndex, x, y, z, w);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArgSize(int size) {
        this.setArgSize(this.argIndex, size);
        ++this.argIndex;
        return this;
    }

    public CLKernel putArgs(CLMemory<?> ... values) {
        this.setArgs(this.argIndex, values);
        this.argIndex += values.length;
        return this;
    }

    public CLKernel rewind() {
        this.argIndex = 0;
        return this;
    }

    public int position() {
        return this.argIndex;
    }

    public CLKernel setArg(int argumentIndex, Buffer value) {
        if (!value.isDirect()) {
            throw new IllegalArgumentException("buffer must be direct.");
        }
        this.setArgument(argumentIndex, Buffers.sizeOfBufferElem(value) * value.remaining(), value);
        return this;
    }

    public CLKernel setArg(int argumentIndex, CLMemory<?> value) {
        this.setArgument(argumentIndex, Platform.is32Bit() ? 4 : 8, this.wrap(value.ID));
        return this;
    }

    public CLKernel setArg(int argumentIndex, short value) {
        this.setArgument(argumentIndex, 2, this.wrap(value));
        return this;
    }

    public CLKernel setArg(int argumentIndex, short x, short y) {
        this.setArgument(argumentIndex, 4, this.wrap(x, y));
        return this;
    }

    public CLKernel setArg(int argumentIndex, short x, short y, short z) {
        this.setArgument(argumentIndex, 6, this.wrap(x, y, z));
        return this;
    }

    public CLKernel setArg(int argumentIndex, short x, short y, short z, short w) {
        this.setArgument(argumentIndex, 8, this.wrap(x, y, z, w));
        return this;
    }

    public CLKernel setArg(int argumentIndex, int value) {
        this.setArgument(argumentIndex, 4, this.wrap(value));
        return this;
    }

    public CLKernel setArg(int argumentIndex, int x, int y) {
        this.setArgument(argumentIndex, 8, this.wrap(x, y));
        return this;
    }

    public CLKernel setArg(int argumentIndex, int x, int y, int z) {
        this.setArgument(argumentIndex, 12, this.wrap(x, y, z));
        return this;
    }

    public CLKernel setArg(int argumentIndex, int x, int y, int z, int w) {
        this.setArgument(argumentIndex, 16, this.wrap(x, y, z, w));
        return this;
    }

    public CLKernel setArg(int argumentIndex, long value) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 4, this.wrap((int)value));
        } else {
            this.setArgument(argumentIndex, 8, this.wrap(value));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, long x, long y) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 8, this.wrap((int)x, (int)y));
        } else {
            this.setArgument(argumentIndex, 16, this.wrap(x, y));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, long x, long y, long z) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 12, this.wrap((int)x, (int)y, (int)z));
        } else {
            this.setArgument(argumentIndex, 24, this.wrap(x, y, z));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, long x, long y, long z, long w) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 16, this.wrap((int)x, (int)y, (int)z, (int)w));
        } else {
            this.setArgument(argumentIndex, 32, this.wrap(x, y, z, w));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, float value) {
        this.setArgument(argumentIndex, 4, this.wrap(value));
        return this;
    }

    public CLKernel setArg(int argumentIndex, float x, float y) {
        this.setArgument(argumentIndex, 8, this.wrap(x, y));
        return this;
    }

    public CLKernel setArg(int argumentIndex, float x, float y, float z) {
        this.setArgument(argumentIndex, 12, this.wrap(x, y, z));
        return this;
    }

    public CLKernel setArg(int argumentIndex, float x, float y, float z, float w) {
        this.setArgument(argumentIndex, 16, this.wrap(x, y, z, w));
        return this;
    }

    public CLKernel setArg(int argumentIndex, double value) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 4, this.wrap((float)value));
        } else {
            this.setArgument(argumentIndex, 8, this.wrap(value));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, double x, double y) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 8, this.wrap((float)x, (float)y));
        } else {
            this.setArgument(argumentIndex, 16, this.wrap(x, y));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, double x, double y, double z) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 12, this.wrap((float)x, (float)y, (float)z));
        } else {
            this.setArgument(argumentIndex, 24, this.wrap(x, y, z));
        }
        return this;
    }

    public CLKernel setArg(int argumentIndex, double x, double y, double z, double w) {
        if (this.force32BitArgs) {
            this.setArgument(argumentIndex, 16, this.wrap((float)x, (float)y, (float)z, (float)w));
        } else {
            this.setArgument(argumentIndex, 32, this.wrap(x, y, z, w));
        }
        return this;
    }

    public CLKernel setArgSize(int argumentIndex, int size) {
        this.setArgument(argumentIndex, size, null);
        return this;
    }

    public CLKernel setArgs(CLMemory<?> ... values) {
        this.setArgs(0, values);
        return this;
    }

    public CLKernel setArgs(Object ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values array was empty or null.");
        }
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof CLMemory) {
                this.setArg(i, (CLMemory)value);
                continue;
            }
            if (value instanceof Short) {
                this.setArg(i, (Short)value);
                continue;
            }
            if (value instanceof Integer) {
                this.setArg(i, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.setArg(i, (Long)value);
                continue;
            }
            if (value instanceof Float) {
                this.setArg(i, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.setArg(i, (Double)value);
                continue;
            }
            if (value instanceof Buffer) {
                this.setArg(i, (Buffer)value);
                continue;
            }
            throw new IllegalArgumentException(value + " is not a valid argument.");
        }
        return this;
    }

    private void setArgs(int startIndex, CLMemory<?> ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.setArg(i + startIndex, values[i]);
        }
    }

    private void setArgument(int argumentIndex, int size, Buffer value) {
        if (argumentIndex >= this.numArgs || argumentIndex < 0) {
            throw new IndexOutOfBoundsException("kernel " + this + " has " + this.numArgs + " arguments, can not set argument with index " + argumentIndex);
        }
        if (!this.program.isExecutable()) {
            throw new IllegalStateException("can not set program arguments for a not executable program. " + this.program);
        }
        int ret = this.binding.clSetKernelArg(this.ID, argumentIndex, size, value);
        if (ret != 0) {
            throw CLException.newException(ret, "error setting arg " + argumentIndex + " to value " + value + " of size " + size + " of " + this);
        }
    }

    public CLKernel setForce32BitArgs(boolean force) {
        this.force32BitArgs = force;
        return this;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public boolean isForce32BitArgsEnabled() {
        return this.force32BitArgs;
    }

    private Buffer wrap(float value) {
        return this.buffer.putFloat(0, value);
    }

    private Buffer wrap(float a, float b) {
        return this.buffer.putFloat(0, a).putFloat(4, b);
    }

    private Buffer wrap(float a, float b, float c) {
        return this.buffer.putFloat(0, a).putFloat(4, b).putFloat(8, c);
    }

    private Buffer wrap(float a, float b, float c, float d) {
        return this.buffer.putFloat(0, a).putFloat(4, b).putFloat(8, c).putFloat(12, d);
    }

    private Buffer wrap(double value) {
        return this.buffer.putDouble(0, value);
    }

    private Buffer wrap(double a, double b) {
        return this.buffer.putDouble(0, a).putDouble(8, b);
    }

    private Buffer wrap(double a, double b, double c) {
        return this.buffer.putDouble(0, a).putDouble(8, b).putDouble(16, c);
    }

    private Buffer wrap(double a, double b, double c, double d) {
        return this.buffer.putDouble(0, a).putDouble(8, b).putDouble(16, c).putDouble(24, d);
    }

    private Buffer wrap(short value) {
        return this.buffer.putShort(0, value);
    }

    private Buffer wrap(short a, short b) {
        return this.buffer.putShort(0, a).putShort(2, b);
    }

    private Buffer wrap(short a, short b, short c) {
        return this.buffer.putShort(0, a).putShort(2, b).putShort(4, c);
    }

    private Buffer wrap(short a, short b, short c, short d) {
        return this.buffer.putShort(0, a).putShort(2, b).putShort(4, c).putShort(6, d);
    }

    private Buffer wrap(int value) {
        return this.buffer.putInt(0, value);
    }

    private Buffer wrap(int a, int b) {
        return this.buffer.putInt(0, a).putInt(4, b);
    }

    private Buffer wrap(int a, int b, int c) {
        return this.buffer.putInt(0, a).putInt(4, b).putInt(8, c);
    }

    private Buffer wrap(int a, int b, int c, int d) {
        return this.buffer.putInt(0, a).putInt(4, b).putInt(8, c).putInt(12, d);
    }

    private Buffer wrap(long value) {
        return this.buffer.putLong(0, value);
    }

    private Buffer wrap(long a, long b) {
        return this.buffer.putLong(0, a).putLong(8, b);
    }

    private Buffer wrap(long a, long b, long c) {
        return this.buffer.putLong(0, a).putLong(8, b).putLong(16, c);
    }

    private Buffer wrap(long a, long b, long c, long d) {
        return this.buffer.putLong(0, a).putLong(8, b).putLong(16, c).putLong(24, d);
    }

    public long getLocalMemorySize(CLDevice device) {
        return this.getWorkGroupInfo(device, 4530);
    }

    public long getWorkGroupSize(CLDevice device) {
        return this.getWorkGroupInfo(device, 4528);
    }

    public long getPreferredWorkGroupSizeMultiple(CLDevice device) {
        return this.getWorkGroupInfo(device, 4531);
    }

    public long[] getCompileWorkGroupSize(CLDevice device) {
        int ret = this.binding.clGetKernelWorkGroupInfo(this.ID, device.ID, 4529, (Platform.is32Bit() ? 4 : 8) * 3, this.buffer, null);
        if (ret != 0) {
            throw CLException.newException(ret, "error while asking for CL_KERNEL_COMPILE_WORK_GROUP_SIZE of " + this + " on " + device);
        }
        if (Platform.is32Bit()) {
            return new long[]{this.buffer.getInt(0), this.buffer.getInt(4), this.buffer.getInt(8)};
        }
        return new long[]{this.buffer.getLong(0), this.buffer.getLong(8), this.buffer.getLong(16)};
    }

    private long getWorkGroupInfo(CLDevice device, int flag) {
        int ret = this.binding.clGetKernelWorkGroupInfo(this.ID, device.ID, flag, 8L, this.buffer, null);
        if (ret != 0) {
            throw CLException.newException(ret, "error while asking for clGetKernelWorkGroupInfo of " + this + " on " + device);
        }
        return this.buffer.getLong(0);
    }

    @Override
    public synchronized void release() {
        super.release();
        int ret = this.binding.clReleaseKernel(this.ID);
        this.program.onKernelReleased(this);
        if (ret != 0) {
            throw CLException.newException(ret, "can not release " + this);
        }
    }

    @Override
    public String toString() {
        return "CLKernel [id: " + this.ID + " name: " + this.name + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLKernel other = (CLKernel)obj;
        if (this.ID != other.ID) {
            return false;
        }
        return this.program.equals(other.program);
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (int)(this.ID ^ this.ID >>> 32);
        hash = 43 * hash + (this.program != null ? this.program.hashCode() : 0);
        return hash;
    }

    public CLKernel clone() {
        return this.program.createCLKernel(this.name).setForce32BitArgs(this.force32BitArgs);
    }
}

